/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.TypedPropertyCriteria;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPMappingConfiguration;
import org.picketlink.idm.credential.handler.annotations.CredentialHandlers;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.internal.AbstractIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPOperationManager;
import org.picketlink.idm.ldap.internal.LDAPPlainTextPasswordCredentialHandler;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.annotation.AttributeProperty;
import org.picketlink.idm.query.AttributeParameter;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.RelationshipQueryParameter;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;

@CredentialHandlers(value={LDAPPlainTextPasswordCredentialHandler.class})
public class LDAPIdentityStore
extends AbstractIdentityStore<LDAPIdentityStoreConfiguration>
implements CredentialStore<LDAPIdentityStoreConfiguration> {
    private LDAPOperationManager operationManager;

    @Override
    public void setup(LDAPIdentityStoreConfiguration config) {
        super.setup(config);
        try {
            this.operationManager = new LDAPOperationManager((LDAPIdentityStoreConfiguration)this.getConfig());
        }
        catch (NamingException e) {
            throw IDMMessages.MESSAGES.storeLdapCouldNotCreateContext((Throwable)e);
        }
    }

    @Override
    public void addAttributedType(IdentityContext context, AttributedType attributedType) {
        if (Relationship.class.isInstance(attributedType)) {
            this.storeRelationship((Relationship)attributedType);
        } else {
            AttributedType parentType;
            Property parentProperty;
            BasicAttributes entryAttributes = this.extractAttributes(attributedType);
            BasicAttribute objectClassAttribute = new BasicAttribute("objectclass");
            LDAPMappingConfiguration ldapEntryConfig = this.getMappingConfig(attributedType.getClass());
            for (String objectClassValue : ldapEntryConfig.getObjectClasses()) {
                objectClassAttribute.add(objectClassValue);
            }
            entryAttributes.put(objectClassAttribute);
            if (ldapEntryConfig.getObjectClasses().contains("groupOfNames")) {
                entryAttributes.put("member", "cn=empty-member," + ((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN());
            }
            this.operationManager.createSubContext(this.getBindingDN(attributedType), entryAttributes);
            if (ldapEntryConfig.getParentMembershipAttributeName() != null && (parentProperty = PropertyQueries.createQuery(attributedType.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(attributedType.getClass())).getFirstResult()) != null && (parentType = (AttributedType)parentProperty.getValue((Object)attributedType)) != null) {
                NamingEnumeration<SearchResult> search = null;
                try {
                    search = this.lookupEntryByID(parentType.getId(), this.getBaseDN(parentType));
                    if (search.hasMore()) {
                        SearchResult next = search.next();
                        Attribute attribute = next.getAttributes().get(ldapEntryConfig.getParentMembershipAttributeName());
                        attribute.add(this.getBindingDN(attributedType));
                        this.operationManager.modifyAttribute(this.getBindingDN(parentType), attribute);
                    }
                }
                catch (NamingException ne) {
                    throw new IdentityManagementException("Could not create parent [" + parentType + "] child [" + attributedType + "] hierarchy.", (Throwable)ne);
                }
                finally {
                    this.safeClose(search);
                }
            }
            NamingEnumeration<SearchResult> search = null;
            try {
                search = this.operationManager.search(this.getBaseDN(attributedType), "(" + this.getBindingName(attributedType) + ")");
                this.populateAttributedType(context, search.next(), attributedType);
            }
            catch (NamingException ne) {
                throw new IdentityManagementException("Could not add AttributedType [" + attributedType + "].", (Throwable)ne);
            }
            finally {
                this.safeClose(search);
            }
        }
    }

    @Override
    public void updateAttributedType(IdentityContext context, AttributedType attributedType) {
        if (Relationship.class.isInstance(attributedType)) {
            throw IDMMessages.MESSAGES.attributedTypeUnsupportedOperation(attributedType.getClass(), IdentityStoreConfiguration.IdentityOperation.update, attributedType.getClass(), IdentityStoreConfiguration.IdentityOperation.update);
        }
        BasicAttributes updatedAttributes = this.extractAttributes(attributedType);
        NamingEnumeration<Attribute> attributes = updatedAttributes.getAll();
        String bindingDN = this.getBindingDN(attributedType);
        try {
            while (attributes.hasMore()) {
                this.operationManager.modifyAttribute(bindingDN, attributes.next());
            }
        }
        catch (NamingException ne) {
            throw new IdentityManagementException("Could not update attributes.", (Throwable)ne);
        }
        finally {
            this.safeClose(attributes);
        }
    }

    @Override
    public void removeAttributedType(IdentityContext context, AttributedType attributedType) {
        if (Relationship.class.isInstance(attributedType)) {
            Relationship relationship = (Relationship)attributedType;
            LDAPMappingConfiguration mappingConfig = this.getMappingConfig(relationship.getClass());
            Property property = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(mappingConfig.getRelatedAttributedType())).getSingleResult();
            AttributedType relationalAttributedType = (AttributedType)property.getValue((Object)relationship);
            NamingEnumeration<SearchResult> search = null;
            try {
                search = this.lookupEntryByID(relationalAttributedType.getId(), this.getBaseDN(relationalAttributedType));
                Attributes attributes = search.next().getAttributes();
                for (Map.Entry entry : mappingConfig.getMappedProperties().entrySet()) {
                    String relBindingDN;
                    Property relProperty = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{(String)entry.getKey()})).getSingleResult();
                    AttributedType relType = (AttributedType)relProperty.getValue((Object)relationship);
                    Attribute attribute = attributes.get((String)entry.getValue());
                    if (attribute != null && attribute.contains(relBindingDN = this.getBindingDN(relType))) {
                        attribute.remove(relBindingDN);
                    }
                    this.operationManager.modifyAttribute(this.getBindingDN(relationalAttributedType), attribute);
                }
            }
            catch (NamingException e) {
                throw new IdentityManagementException("Could not remove referenced types from relationship type.", (Throwable)e);
            }
            finally {
                this.safeClose(search);
            }
        }
        List relationshipConfigs = ((LDAPIdentityStoreConfiguration)this.getConfig()).getRelationshipConfigs();
        String bindingDN = this.getBindingDN(attributedType);
        try {
            for (LDAPMappingConfiguration relationshipConfig : relationshipConfigs) {
                for (String attributeName : relationshipConfig.getMappedProperties().values()) {
                    StringBuilder filter = new StringBuilder();
                    filter.append("(&(").append(attributeName).append("=").append("").append(bindingDN).append("))");
                    NamingEnumeration<SearchResult> search = this.operationManager.search(this.getMappingConfig(relationshipConfig.getRelatedAttributedType()).getBaseDN(), filter.toString());
                    while (search.hasMore()) {
                        SearchResult result = search.next();
                        Attributes attributes = result.getAttributes();
                        Attribute relationshipAttribute = attributes.get(attributeName);
                        if (relationshipAttribute == null || !relationshipAttribute.contains(bindingDN)) continue;
                        relationshipAttribute.remove(bindingDN);
                        if (relationshipAttribute.size() == 0) {
                            relationshipAttribute.add(this.getEmptyMemberDN());
                        }
                        this.operationManager.modifyAttribute(result.getNameInNamespace(), relationshipAttribute);
                    }
                    this.safeClose(search);
                }
            }
        }
        catch (NamingException e) {
            throw new IdentityManagementException((Throwable)e);
        }
        this.operationManager.removeEntryById(this.getBaseDN(attributedType), attributedType.getId());
    }

    public <V extends IdentityType> List<V> fetchQueryResults(IdentityContext context, IdentityQuery<V> identityQuery) {
        ArrayList<IdentityType> results = new ArrayList<IdentityType>();
        if (identityQuery.getParameter(IdentityType.ID) != null) {
            Object[] queryParameterValues = identityQuery.getParameter(IdentityType.ID);
            NamingEnumeration<SearchResult> search = this.lookupEntryByID(queryParameterValues[0].toString(), ((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN());
            try {
                while (search.hasMore()) {
                    results.add((IdentityType)this.populateAttributedType(context, search.next(), null));
                }
            }
            catch (NamingException ne) {
                throw new IdentityManagementException("Could not create identity type from LDAP entry.", (Throwable)ne);
            }
            finally {
                this.safeClose(search);
            }
            return results;
        }
        LDAPMappingConfiguration ldapEntryConfig = this.getMappingConfig(identityQuery.getIdentityType());
        StringBuilder filter = new StringBuilder();
        for (Map.Entry entry : identityQuery.getParameters().entrySet()) {
            QueryParameter queryParameter = (QueryParameter)entry.getKey();
            Object[] queryParameterValues = (Object[])entry.getValue();
            if (queryParameterValues.length <= 0 || IdentityType.ID.equals(queryParameter) || !AttributeParameter.class.isInstance(queryParameter)) continue;
            AttributeParameter attributeParameter = (AttributeParameter)queryParameter;
            String ldapAttributeName = (String)ldapEntryConfig.getMappedProperties().get(attributeParameter.getName());
            if (ldapAttributeName == null) continue;
            Object value = queryParameterValues[0];
            if (Date.class.isInstance(value)) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
                formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
                value = formatter.format((Date)value);
            }
            if (queryParameter.equals(IdentityType.CREATED_AFTER)) {
                filter.append("(").append(ldapAttributeName).append(">=").append(value).append(")");
                continue;
            }
            if (queryParameter.equals(IdentityType.CREATED_BEFORE)) {
                filter.append("(").append(ldapAttributeName).append("<=").append(value).append(")");
                continue;
            }
            filter.append("(").append(ldapAttributeName).append("=").append(value).append(")");
        }
        if (filter.length() != 0) {
            NamingEnumeration<SearchResult> search = null;
            try {
                String baseDN = ((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN();
                if (ldapEntryConfig != null) {
                    baseDN = ldapEntryConfig.getBaseDN();
                }
                filter.insert(0, "(&(");
                for (String objectClass : ldapEntryConfig.getObjectClasses()) {
                    filter.append("(objectClass=").append(objectClass).append(")");
                }
                filter.append("))");
                search = this.operationManager.search(baseDN, filter.toString());
                while (search.hasMoreElements()) {
                    IdentityType type = (IdentityType)this.populateAttributedType(context, (SearchResult)search.nextElement(), null);
                    if (type == null) continue;
                    results.add(type);
                }
            }
            catch (Exception e) {
                throw new IdentityManagementException("Could not query identity types.", (Throwable)e);
            }
            finally {
                this.safeClose(search);
            }
        }
        return results;
    }

    public <V extends IdentityType> int countQueryResults(IdentityContext context, IdentityQuery<V> identityQuery) {
        return 0;
    }

    public <V extends Relationship> List<V> fetchQueryResults(IdentityContext context, RelationshipQuery<V> query) {
        ArrayList<Relationship> results;
        block22: {
            LDAPMappingConfiguration mappingConfig = this.getMappingConfig(query.getRelationshipClass());
            Map parameters = query.getParameters();
            StringBuilder filter = new StringBuilder();
            ArrayList<AttributedType> referencedTypes = new ArrayList<AttributedType>();
            for (QueryParameter queryParameter : parameters.keySet()) {
                Object[] values = (Object[])parameters.get(queryParameter);
                if (!RelationshipQueryParameter.class.isInstance(queryParameter)) continue;
                RelationshipQueryParameter relationshipQueryParameter = (RelationshipQueryParameter)queryParameter;
                String attributeName = (String)mappingConfig.getMappedProperties().get(relationshipQueryParameter.getName());
                for (Object value : values) {
                    AttributedType attributedType = (AttributedType)value;
                    if (attributeName != null) {
                        filter.append("(").append(attributeName).append("=").append("").append(this.getBindingDN(attributedType)).append(")");
                        continue;
                    }
                    referencedTypes.add(attributedType);
                }
            }
            results = new ArrayList<Relationship>();
            NamingEnumeration<SearchResult> search = null;
            try {
                if (!referencedTypes.isEmpty()) {
                    for (AttributedType relFilter : referencedTypes) {
                        search = this.operationManager.search(this.getBaseDN(relFilter), this.getBindingName(relFilter));
                        List properties = PropertyQueries.createQuery((Class)query.getRelationshipClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(IdentityType.class, TypedPropertyCriteria.MatchOption.SUB_TYPE)).getResultList();
                        Property rootProperty = PropertyQueries.createQuery((Class)query.getRelationshipClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(mappingConfig.getRelatedAttributedType())).getSingleResult();
                        while (search.hasMore()) {
                            SearchResult next = search.next();
                            Attributes attributes = next.getAttributes();
                            for (Property property : properties) {
                                if (property.getJavaClass().equals(relFilter.getClass())) continue;
                                String relAttributeName = (String)mappingConfig.getMappedProperties().get(property.getName());
                                Attribute attribute = attributes.get(relAttributeName);
                                for (QueryParameter queryParameter : parameters.keySet()) {
                                    Object[] values = (Object[])parameters.get(queryParameter);
                                    if (!RelationshipQueryParameter.class.isInstance(queryParameter)) continue;
                                    RelationshipQueryParameter relationshipQueryParameter = (RelationshipQueryParameter)queryParameter;
                                    if (filter.length() > 0) {
                                        Object value;
                                        AttributedType relType;
                                        if (!relationshipQueryParameter.getName().equals(property.getName())) continue;
                                        Object[] arr$ = values;
                                        int len$ = arr$.length;
                                        for (int i$ = 0; i$ < len$ && attribute.contains(this.getBindingDN(relType = (AttributedType)(value = arr$[i$]))); ++i$) {
                                            Relationship relationship = (Relationship)query.getRelationshipClass().newInstance();
                                            rootProperty.setValue((Object)relationship, (Object)this.populateAttributedType(context, next, null));
                                            property.setValue((Object)relationship, (Object)relType);
                                            results.add(relationship);
                                        }
                                        continue;
                                    }
                                    NamingEnumeration<?> all = attribute.getAll();
                                    while (all.hasMore()) {
                                        String member = all.next().toString();
                                        if (this.isEmptyMember(member) || StringUtil.isNullOrEmpty((String)member.trim())) continue;
                                        Relationship relationship = (Relationship)query.getRelationshipClass().newInstance();
                                        rootProperty.setValue((Object)relationship, (Object)this.populateAttributedType(context, next, null));
                                        String baseDN = member.substring(member.indexOf(",") + 1);
                                        String dn = member.substring(0, member.indexOf(","));
                                        NamingEnumeration<SearchResult> result = this.operationManager.search(baseDN, dn);
                                        if (!result.hasMore()) {
                                            throw new IdentityManagementException("Associated entry does not exists [" + member + "].");
                                        }
                                        property.setValue((Object)relationship, (Object)this.populateAttributedType(context, result.next(), null));
                                        results.add(relationship);
                                    }
                                }
                            }
                        }
                    }
                    break block22;
                }
                if (filter.length() > 0) {
                    search = this.operationManager.search(this.getMappingConfig(mappingConfig.getRelatedAttributedType()).getBaseDN(), filter.toString());
                    Property property = PropertyQueries.createQuery((Class)query.getRelationshipClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(mappingConfig.getRelatedAttributedType())).getSingleResult();
                    while (search.hasMore()) {
                        SearchResult next = search.next();
                        Attributes attributes = next.getAttributes();
                        for (Map.Entry memberAttribute : mappingConfig.getMappedProperties().entrySet()) {
                            Attribute attribute = attributes.get((String)memberAttribute.getValue());
                            NamingEnumeration<?> attributeValues = attribute.getAll();
                            while (attributeValues.hasMore()) {
                                String dn;
                                String value = attributeValues.next().toString();
                                if (this.isEmptyMember(value) || StringUtil.isNullOrEmpty((String)value.trim())) continue;
                                Property associatedProperty = PropertyQueries.createQuery((Class)query.getRelationshipClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{(String)memberAttribute.getKey()})).getSingleResult();
                                String baseDN = value.substring(value.indexOf(",") + 1);
                                NamingEnumeration<SearchResult> result = this.operationManager.search(baseDN, dn = value.substring(0, value.indexOf(",")));
                                if (!result.hasMore()) {
                                    throw new IdentityManagementException("Associated entry does not exists [" + value + "].");
                                }
                                AttributedType ownerRelType = this.populateAttributedType(context, next, null);
                                if (!property.getJavaClass().isAssignableFrom(ownerRelType.getClass())) continue;
                                Relationship relationship = (Relationship)query.getRelationshipClass().newInstance();
                                property.setValue((Object)relationship, (Object)ownerRelType);
                                SearchResult member = result.next();
                                AttributedType relType = this.populateAttributedType(context, member, null);
                                if (!associatedProperty.getJavaClass().isAssignableFrom(relType.getClass())) continue;
                                associatedProperty.setValue((Object)relationship, (Object)relType);
                                results.add(relationship);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw IDMMessages.MESSAGES.queryRelationshipFailed(query, (Throwable)e);
            }
            finally {
                this.safeClose(search);
            }
        }
        return results;
    }

    private boolean isEmptyMember(String value) {
        return value.contains(this.getEmptyMemberDN());
    }

    private String getEmptyMemberDN() {
        return "cn=empty-member," + ((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN();
    }

    public <V extends Relationship> int countQueryResults(IdentityContext context, RelationshipQuery<V> query) {
        return 0;
    }

    public void storeCredential(IdentityContext context, Account account, CredentialStorage storage) {
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(IdentityContext context, Account account, Class<T> storageClass) {
        return null;
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(IdentityContext context, Account account, Class<T> storageClass) {
        return null;
    }

    private void storeRelationship(Relationship relationship) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(relationship.getClass());
        Property property = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(mappingConfig.getRelatedAttributedType())).getSingleResult();
        AttributedType relationalAttributedType = (AttributedType)property.getValue((Object)relationship);
        NamingEnumeration<SearchResult> search = null;
        try {
            search = this.lookupEntryByID(relationalAttributedType.getId(), this.getBaseDN(relationalAttributedType));
            Attributes attributes = search.next().getAttributes();
            for (Map.Entry entry : mappingConfig.getMappedProperties().entrySet()) {
                Property relProperty = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{(String)entry.getKey()})).getSingleResult();
                AttributedType relType = (AttributedType)relProperty.getValue((Object)relationship);
                Attribute attribute = attributes.get((String)entry.getValue());
                if (attribute == null) {
                    attribute = new BasicAttribute((String)entry.getValue());
                    attributes.put(attribute);
                }
                attribute.add(this.getBindingDN(relType));
                this.operationManager.modifyAttribute(this.getBindingDN(relationalAttributedType), attribute);
            }
        }
        catch (NamingException e) {
            throw new IdentityManagementException("Could not store relationship.", (Throwable)e);
        }
        finally {
            this.safeClose(search);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributedType populateAttributedType(IdentityContext context, SearchResult searchResult, AttributedType attributedType) {
        block12: {
            try {
                String nameInNamespace = searchResult.getNameInNamespace();
                String entryDN = nameInNamespace.substring(nameInNamespace.indexOf(",") + 1);
                Attributes attributes = searchResult.getAttributes();
                if (attributedType == null) {
                    attributedType = (AttributedType)((LDAPIdentityStoreConfiguration)this.getConfig()).getSupportedTypeByBaseDN(entryDN).newInstance();
                }
                LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
                NamingEnumeration<? extends Attribute> ldapAttributes = attributes.getAll();
                while (ldapAttributes.hasMore()) {
                    Attribute ldapAttribute = ldapAttributes.next();
                    Object value = ldapAttribute.get();
                    if (ldapAttribute.getID().equals("entryUUID")) {
                        attributedType.setId(value.toString());
                        continue;
                    }
                    List properties = PropertyQueries.createQuery(attributedType.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(AttributeProperty.class)).getResultList();
                    for (Property property : properties) {
                        String ldapAttributeName = (String)mappingConfig.getMappedProperties().get(property.getName());
                        if (ldapAttributeName == null || !ldapAttributeName.equals(ldapAttribute.getID())) continue;
                        if (property.getJavaClass().equals(Date.class)) {
                            property.setValue((Object)attributedType, (Object)this.parseLDAPDate(value.toString()));
                            continue;
                        }
                        property.setValue((Object)attributedType, value);
                    }
                }
                if (IdentityType.class.isInstance(attributedType)) {
                    IdentityType identityType = (IdentityType)attributedType;
                    String createdTimestamp = attributes.get("createTimeStamp").get().toString();
                    identityType.setCreatedDate(this.parseLDAPDate(createdTimestamp));
                    identityType.setPartition(context.getPartition());
                }
                if (mappingConfig.getParentMembershipAttributeName() == null) break block12;
                StringBuilder filter = new StringBuilder("(|");
                filter.append("(").append(mappingConfig.getParentMembershipAttributeName()).append("=").append("").append(this.getBindingName(attributedType)).append(",").append(entryDN).append(")");
                filter.append(")");
                NamingEnumeration<SearchResult> search = this.operationManager.search(((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN(), filter.toString());
                try {
                    while (search.hasMore()) {
                        SearchResult next = search.next();
                        Property parentProperty = PropertyQueries.createQuery(attributedType.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(attributedType.getClass())).getFirstResult();
                        if (parentProperty == null) continue;
                        String baseDN = next.getNameInNamespace().substring(next.getNameInNamespace().indexOf(",") + 1);
                        Class baseDNType = ((LDAPIdentityStoreConfiguration)this.getConfig()).getSupportedTypeByBaseDN(baseDN);
                        if (!parentProperty.getJavaClass().isAssignableFrom(baseDNType)) continue;
                        parentProperty.setValue((Object)attributedType, (Object)this.populateAttributedType(context, next, null));
                    }
                }
                finally {
                    this.safeClose(search);
                }
            }
            catch (Exception e) {
                throw new IdentityManagementException("Could not populate attribute type.", (Throwable)e);
            }
        }
        return attributedType;
    }

    private String getBindingName(AttributedType attributedType) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
        Property idProperty = mappingConfig.getIdProperty();
        return (String)mappingConfig.getMappedProperties().get(idProperty.getName()) + "=" + (String)idProperty.getValue((Object)attributedType);
    }

    private BasicAttributes extractAttributes(AttributedType attributedType) {
        BasicAttributes ldapEntryAttributes = new BasicAttributes();
        Map mappedProperties = this.getMappingConfig(attributedType.getClass()).getMappedProperties();
        for (String propertyName : mappedProperties.keySet()) {
            if (this.getMappingConfig(attributedType.getClass()).getReadOnlyAttributes().contains(propertyName)) continue;
            Property property = PropertyQueries.createQuery(attributedType.getClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{propertyName})).getSingleResult();
            Object propertyValue = property.getValue((Object)attributedType);
            if (AttributedType.class.isInstance(propertyValue)) {
                AttributedType referencedType = (AttributedType)propertyValue;
                propertyValue = this.getBindingDN(referencedType);
            } else if (propertyValue == null || StringUtil.isNullOrEmpty((String)propertyValue.toString())) {
                propertyValue = " ";
            }
            ldapEntryAttributes.put((String)mappedProperties.get(propertyName), propertyValue);
        }
        return ldapEntryAttributes;
    }

    private String getCustomAttributesDN(AttributedType attributedType) {
        return "cn=custom-attributes," + this.getBindingDN(attributedType);
    }

    private LDAPMappingConfiguration getMappingConfig(Class<? extends AttributedType> attributedType) {
        LDAPMappingConfiguration mappingConfig = ((LDAPIdentityStoreConfiguration)this.getConfig()).getMappingConfig(attributedType);
        if (mappingConfig == null) {
            throw new IdentityManagementException("Not mapped type [" + attributedType + "].");
        }
        return mappingConfig;
    }

    NamingEnumeration<SearchResult> lookupEntryByID(String id, String baseDN) {
        return this.operationManager.lookupById(baseDN, id);
    }

    LDAPOperationManager getOperationManager() {
        return this.operationManager;
    }

    String getBindingDN(AttributedType attributedType) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
        Property idProperty = mappingConfig.getIdProperty();
        return (String)mappingConfig.getMappedProperties().get(idProperty.getName()) + "=" + (String)idProperty.getValue((Object)attributedType) + "," + this.getBaseDN(attributedType);
    }

    private String getBaseDN(AttributedType attributedType) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
        String baseDN = mappingConfig.getBaseDN();
        String mappingDN = (String)mappingConfig.getParentMapping().get(mappingConfig.getIdProperty().getValue((Object)attributedType));
        if (mappingDN != null) {
            baseDN = mappingDN;
        } else {
            AttributedType parentType;
            Property parentProperty = PropertyQueries.createQuery(attributedType.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(attributedType.getClass())).getFirstResult();
            if (parentProperty != null && (parentType = (AttributedType)parentProperty.getValue((Object)attributedType)) != null) {
                Property parentIdProperty = this.getMappingConfig(parentType.getClass()).getIdProperty();
                String parentId = (String)parentIdProperty.getValue((Object)parentType);
                String parentBaseDN = (String)mappingConfig.getParentMapping().get(parentId);
                baseDN = parentBaseDN != null ? parentBaseDN : this.getBaseDN(parentType);
            }
        }
        return baseDN;
    }

    private Date parseLDAPDate(String dateText) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            if (dateText.endsWith("Z")) {
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                dateFormat.setTimeZone(TimeZone.getDefault());
            }
            return dateFormat.parse(dateText);
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error converting ldap date.", (Throwable)e);
        }
    }

    private void safeClose(NamingEnumeration<?> search) {
        if (search != null) {
            try {
                search.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }
}

