/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.query.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.internal.RelationshipReference;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.spi.AttributeStore;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.StoreSelector;

public class DefaultRelationshipQuery<T extends Relationship>
implements RelationshipQuery<T> {
    private Map<QueryParameter, Object[]> parameters = new LinkedHashMap<QueryParameter, Object[]>();
    private IdentityContext context;
    private StoreSelector storeSelector;
    private Class<T> relationshipClass;
    private long offset;
    private long limit;

    public DefaultRelationshipQuery(IdentityContext context, Class<T> relationshipClass, StoreSelector storeSelector) {
        this.context = context;
        this.relationshipClass = relationshipClass;
        this.storeSelector = storeSelector;
    }

    public RelationshipQuery<T> setParameter(QueryParameter param, Object ... value) {
        this.parameters.put(param, value);
        return this;
    }

    public Class<T> getRelationshipClass() {
        return this.relationshipClass;
    }

    public Map<QueryParameter, Object[]> getParameters() {
        return this.parameters;
    }

    public Object[] getParameter(QueryParameter queryParameter) {
        return this.parameters.get(queryParameter);
    }

    public long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public List<T> getResultList() {
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        try {
            for (IdentityStore<?> store : this.getStores()) {
                List references = store.fetchQueryResults(this.context, (RelationshipQuery)this);
                for (Relationship relationship : references) {
                    AttributeStore attributeStore;
                    if (RelationshipReference.class.isInstance(relationship)) {
                        RelationshipReference reference = (RelationshipReference)relationship;
                        this.resolveIdentityTypes(reference);
                        relationship = reference.getRelationship();
                    }
                    if ((attributeStore = this.storeSelector.getStoreForAttributeOperation(this.context)) != null) {
                        attributeStore.loadAttributes(this.context, (AttributedType)relationship);
                    }
                    result.add(relationship);
                }
            }
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.queryRelationshipFailed((RelationshipQuery)this, (Throwable)e);
        }
        return result;
    }

    private void resolveIdentityTypes(RelationshipReference reference) {
        Relationship relationship = reference.getRelationship();
        for (String descriptor : reference.getDescriptors()) {
            String partitionId = reference.getPartitionId(descriptor);
            String identityTypeId = reference.getIdentityTypeId(descriptor);
            PartitionManager partitionManager = (PartitionManager)this.storeSelector;
            Partition partition = partitionManager.lookupById(Partition.class, partitionId);
            if (partition == null) {
                throw new IdentityManagementException("No partition [" + partitionId + "] found for " + "referenced IdentityType [" + identityTypeId + "].");
            }
            IdentityManager identityManager = partitionManager.createIdentityManager(partition);
            IdentityType identityType = identityManager.lookupIdentityById(IdentityType.class, identityTypeId);
            if (identityType == null) {
                throw new IdentityManagementException("Referenced IdentityType [" + identityTypeId + "] from " + "" + "relationship " + "[" + relationship.getClass() + "] does not exists in any store.");
            }
            Property property = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{descriptor})).getSingleResult();
            property.setValue((Object)relationship, (Object)identityType);
        }
    }

    public long getResultCount() {
        long count = 0L;
        try {
            for (IdentityStore<?> store : this.getStores()) {
                count += (long)store.countQueryResults(this.context, (RelationshipQuery)this);
            }
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.queryRelationshipFailed((RelationshipQuery)this, (Throwable)e);
        }
        return count;
    }

    public RelationshipQuery<T> setOffset(long offset) {
        this.offset = offset;
        return this;
    }

    public RelationshipQuery<T> setLimit(long limit) {
        this.limit = limit;
        return this;
    }

    private Set<IdentityStore<?>> getStores() {
        HashSet<Partition> partitions = new HashSet<Partition>();
        for (Object[] param : this.parameters.values()) {
            if (!IdentityType.class.isInstance(param)) continue;
            partitions.add(((IdentityType)param).getPartition());
        }
        return this.storeSelector.getStoresForRelationshipQuery(this.context, this.relationshipClass, partitions);
    }
}

