/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm;

import org.jboss.logging.Cause;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;
import org.jboss.logging.Param;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.OperationNotSupportedException;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.spi.IdentityStore;

@MessageBundle(projectCode="PLIDM")
public interface IDMInternalMessages
extends IDMMessages {
    public static final IDMInternalMessages MESSAGES = (IDMInternalMessages)Messages.getBundle(IDMInternalMessages.class);

    @Message(id=6, value="Could not initialize Partition Manager [%s].")
    public IdentityManagementException partitionManagerInitializationFailed(Class<? extends PartitionManager> var1, @Cause Throwable var2);

    @Message(id=300, value="No store found with type [%s].")
    public IdentityManagementException storeNotFound(Class<? extends IdentityStore> var1);

    @Message(id=301, value="Error while trying to determine EntityManager - context parameter not set.")
    public IdentityManagementException storeJpaCouldNotGetEntityManagerFromStoreContext();

    @Message(id=302, value="Could not create context.")
    public IdentityManagementException storeLdapCouldNotCreateContext(@Cause Throwable var1);

    @Message(value="Entry not found with ID [%s] using baseDN [%s].")
    public IdentityManagementException storeLdapEntryNotFoundWithId(String var1, String var2);

    @Message(value="Could not load attributes for entry with ID [%s] using baseDN [%s].")
    public IdentityManagementException storeLdapCouldNotLoadAttributesForEntry(String var1, String var2);

    @Message(value="Unexpected IdentityStore type. Expected [%s]. Actual [%s].")
    public IdentityManagementException storeUnexpectedType(Class<? extends IdentityStore> var1, Class<? extends IdentityStore> var2);

    @Message(id=401, value="Could not create partition [%s] using configuration [%s].")
    public IdentityManagementException partitionAddFailed(Partition var1, String var2, @Cause Exception var3);

    @Message(id=402, value="Could not update partition [%s].")
    public IdentityManagementException partitionUpdateFailed(Partition var1, @Cause Exception var2);

    @Message(id=403, value="Could not remove partition [%s].")
    public IdentityManagementException partitionRemoveFailed(Partition var1, @Cause Exception var2);

    @Message(id=404, value="Could not load partition for type [%s] and name [%s].")
    public IdentityManagementException partitionGetFailed(Class<? extends Partition> var1, String var2, @Cause Exception var3);

    @Message(id=405, value="Could not create contextual IdentityManager for Partition [%s]. Partition not found or it was null.")
    public IdentityManagementException partitionCouldNotCreateIdentityManager(Partition var1);

    @Message(id=406, value="Partition [%s] not found with the given name [%s].")
    public IdentityManagementException partitionNotFoundWithName(Class<? extends Partition> var1, String var2);

    @Message(id=407, value="No configuration found with the given name [%s].")
    public IdentityManagementException partitionNoConfigurationFound(String var1);

    @Message(id=408, value="Partition [%s] references an invalid or non-existent configuration.")
    public IdentityManagementException partitionReferencesInvalidConfiguration(Partition var1);

    @Message(id=409, value="Partition management is not supported by the current configuration.")
    public OperationNotSupportedException partitionManagementNoSupported(@Param Class<Partition> var1, @Param IdentityStoreConfiguration.IdentityOperation var2);

    @Message(id=410, value="Could not create contextual PermissionManager for Partition [%s].")
    public IdentityManagementException partitionCouldNotCreatePermissionManager(Partition var1);

    @Message(id=411, value="Partition [%s] does not support type [%s].")
    public IdentityManagementException partitionUnsupportedType(Partition var1, Class<? extends AttributedType> var2);

    @Message(id=412, value="More than one partitions have been found with the given name [%s] and type [%s].")
    public IdentityManagementException partitionFoundWithSameNameAndType(String var1, Class<? extends Partition> var2);

    @Message(value="A Partition [%s] with name [%s] already exists.")
    public IdentityManagementException partitionAlreadyExistsWithName(Class<? extends Partition> var1, String var2);

    @Message(value="No configuration name defined for partition [%s].")
    public IdentityManagementException partitionWithNoConfigurationName(Partition var1);

    @Message(id=500, value="Could not query Relationship using query [%s].")
    public IdentityManagementException queryRelationshipFailed(RelationshipQuery<?> var1, @Cause Throwable var2);

    @Message(id=501, value="Could not query IdentityType using query [%s].")
    public IdentityManagementException queryIdentityTypeFailed(IdentityQuery<?> var1, @Cause Throwable var2);

    @Message(value="Unsupported value for Query Parameter [%s]. Value: %s.")
    public IdentityManagementException queryUnsupportedParameterValue(String var1, Object var2);

    @Message(id=600, value="Could not add AttributedType [%s].")
    public IdentityManagementException attributedTypeAddFailed(AttributedType var1, @Cause Throwable var2);

    @Message(id=601, value="Could not remove AttributedType [%s].")
    public IdentityManagementException attributedTypeRemoveFailed(AttributedType var1, @Cause Throwable var2);

    @Message(id=602, value="Could not update AttributedType [%s].")
    public IdentityManagementException attributedTypeUpdateFailed(AttributedType var1, @Cause Throwable var2);

    @Message(value="IdentityType [%s] already exists with the given identifier [%s] for the given Partition [%s].")
    public IdentityManagementException identityTypeAlreadyExists(Class<? extends IdentityType> var1, String var2, Partition var3);

    @Message(id=603, value="Ambiguous AttributedType found with identifier [%s].")
    public IdentityManagementException attributedTypeAmbiguosFoundWithId(String var1);

    @Message(id=604, value="No identity store configuration found for requested type operation [%s.%s].")
    public OperationNotSupportedException attributedTypeUnsupportedOperation(@Param Class<? extends AttributedType> var1, @Param IdentityStoreConfiguration.IdentityOperation var2, Class<? extends AttributedType> var3, IdentityStoreConfiguration.IdentityOperation var4);

    @Message(id=605, value="Undefined partition for identity type [%s].")
    public IdentityManagementException attributedUndefinedPartition(IdentityType var1);

    @Message(value="Could not find AttributedType [%s] with the given identifier [%s] for Partition [%s]")
    public IdentityManagementException attributedTypeNotFoundWithId(Class<? extends AttributedType> var1, String var2, Partition var3);

    @Message(id=800, value="No PermissionStore configuration found for requested permission operation.")
    public IdentityManagementException permissionUnsupportedOperation();

    @Message(id=801, value="No @Entity class found to store permissions. Check if you have an @Entity class annotated with @PermissionManaged.")
    public IdentityManagementException configJpaStoreNoPermissionEntityClassProvided();
}

