/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.file;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.file.internal.FileUser;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.User;
import org.picketlink.test.idm.internal.file.AbstractFileIdentityTypeTestCase;

public class FileUserTestCase
extends AbstractFileIdentityTypeTestCase {
    private static final String USER_EMAIL = "myemail@company.com";
    private static final String USER_LAST_NAME = "Saldhana";
    private static final String USER_FIRST_NAME = "Anil";
    private static final String USER_USERNAME = "asaldhana";

    @Test
    public void testUserStore() throws Exception {
        FileUser user = new FileUser(USER_USERNAME);
        this.getIdentityManager().createUser((User)user);
        user.setEmail(USER_EMAIL);
        user.setFirstName(USER_FIRST_NAME);
        user.setLastName(USER_LAST_NAME);
        this.testGetUser();
        this.testAddAttributes();
        this.testRemoveAttributes();
        this.testRemoveUser();
    }

    public void testGetUser() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = identityManager.getUser(USER_USERNAME);
        this.assertUserBasicInformation(user);
    }

    public void testRemoveUser() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = identityManager.getUser(USER_USERNAME);
        junit.framework.Assert.assertNotNull((Object)user);
        identityManager.removeUser(user);
        user = identityManager.getUser(USER_USERNAME);
        Assert.assertNull((Object)user);
    }

    private void assertUserBasicInformation(User user) {
        junit.framework.Assert.assertNotNull((Object)user);
        junit.framework.Assert.assertNotNull((Object)user.getId());
        junit.framework.Assert.assertEquals((String)USER_USERNAME, (String)user.getId());
        junit.framework.Assert.assertEquals((String)USER_FIRST_NAME, (String)user.getFirstName());
        junit.framework.Assert.assertEquals((String)USER_LAST_NAME, (String)user.getLastName());
        junit.framework.Assert.assertEquals((String)USER_EMAIL, (String)user.getEmail());
    }

    @Override
    protected IdentityType getIdentityTypeFromDatabase(IdentityManager identityStore) {
        return this.getIdentityManager().getUser(USER_USERNAME);
    }
}

