/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.jpa;

import org.junit.Assert;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.User;
import org.picketlink.test.idm.internal.jpa.AbstractJPAIdentityTypeTestCase;

public class JPAUserTestCase
extends AbstractJPAIdentityTypeTestCase {
    private static final String USER_EMAIL = "myemail@company.com";
    private static final String USER_LAST_NAME = "Saldhana";
    private static final String USER_FIRST_NAME = "Anil";
    private static final String USER_FULL_NAME = "Anil Saldhana";
    private static final String USER_USERNAME = "asaldhana";

    public void testUserStore() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = identityManager.createUser(USER_USERNAME);
        user.setEmail(USER_EMAIL);
        user.setFirstName(USER_FIRST_NAME);
        user.setLastName(USER_LAST_NAME);
        this.assertUserBasicInformation(user);
        this.testAddAttributes();
        this.testGetUser();
        this.testRemoveUser();
    }

    public void testSimpleUserStore() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        this.testAddAttributes();
        this.testGetUser();
        this.testRemoveUser();
    }

    public void testGetUser() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = identityManager.getUser(USER_USERNAME);
        this.assertUserBasicInformation(user);
        this.testRemoveAttributes();
    }

    public void testRemoveUser() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = identityManager.getUser(USER_USERNAME);
        junit.framework.Assert.assertNotNull((Object)user);
        identityManager.removeUser(user);
        user = identityManager.getUser(USER_USERNAME);
        Assert.assertNull((Object)user);
    }

    private void assertUserBasicInformation(User user) {
        junit.framework.Assert.assertNotNull((Object)user);
        junit.framework.Assert.assertNotNull((Object)user.getId());
        junit.framework.Assert.assertEquals((String)USER_USERNAME, (String)user.getKey());
        junit.framework.Assert.assertEquals((String)USER_FULL_NAME, (String)user.getFullName());
        junit.framework.Assert.assertEquals((String)USER_FIRST_NAME, (String)user.getFirstName());
        junit.framework.Assert.assertEquals((String)USER_LAST_NAME, (String)user.getLastName());
        junit.framework.Assert.assertEquals((String)USER_EMAIL, (String)user.getEmail());
    }

    @Override
    protected IdentityType getIdentityTypeFromDatabase(IdentityManager identityManager) {
        return identityManager.getUser(USER_USERNAME);
    }
}

