/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.ldap;

import org.junit.Before;
import org.picketbox.test.ldap.AbstractLDAPTest;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.internal.DefaultIdentityManager;
import org.picketlink.idm.ldap.internal.LDAPConfiguration;
import org.picketlink.idm.ldap.internal.LDAPConfigurationBuilder;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreConfigurationBuilder;

public abstract class AbstractLDAPIdentityManagerTestCase
extends AbstractLDAPTest {
    private IdentityManager identityManager;

    @Before
    public void setup() throws Exception {
        super.setup();
        this.importLDIF("ldap/users.ldif");
    }

    protected IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            DefaultIdentityManager defaultIdentityManager = new DefaultIdentityManager();
            defaultIdentityManager.setIdentityStore(this.createIdentityStore());
            this.identityManager = defaultIdentityManager;
        }
        return this.identityManager;
    }

    private IdentityStore createIdentityStore() {
        LDAPIdentityStore store = new LDAPIdentityStore();
        store.setConfiguration(this.getConfiguration());
        return store;
    }

    private LDAPConfiguration getConfiguration() {
        String fqn = LDAPConfigurationBuilder.class.getName();
        LDAPConfiguration config = (LDAPConfiguration)IdentityStoreConfigurationBuilder.config((String)fqn);
        config.setBindDN(this.adminDN).setBindCredential(this.adminPW).setLdapURL("ldap://localhost:10389");
        config.setUserDNSuffix("ou=People,dc=jboss,dc=org").setRoleDNSuffix("ou=Roles,dc=jboss,dc=org");
        config.setGroupDNSuffix("ou=Groups,dc=jboss,dc=org");
        return config;
    }
}

