/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.ldap;

import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.picketlink.idm.internal.DefaultIdentityManager;
import org.picketlink.idm.ldap.internal.LDAPConfiguration;
import org.picketlink.idm.ldap.internal.LDAPConfigurationBuilder;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.User;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreConfigurationBuilder;
import org.picketlink.test.idm.internal.ldap.AbstractLDAPIdentityManagerTestCase;

public class LDAPCustomAttributesTestCase
extends AbstractLDAPIdentityManagerTestCase {
    @Override
    public void setup() throws Exception {
        super.setup();
        this.importLDIF("ldap/users.ldif");
    }

    @Test
    @Ignore
    public void testUserAttributes() throws Exception {
        LDAPIdentityStore store = new LDAPIdentityStore();
        store.setConfiguration(this.getConfiguration());
        DefaultIdentityManager im = new DefaultIdentityManager();
        im.setIdentityStore((IdentityStore)store);
        User user = im.createUser("Anil Saldhana");
        Assert.assertNotNull((Object)user);
        User anil = im.getUser("Anil Saldhana");
        Assert.assertNotNull((Object)anil);
        Assert.assertEquals((Object)"Anil Saldhana", (Object)anil.getFullName());
        Assert.assertEquals((Object)"Anil", (Object)anil.getFirstName());
        Assert.assertEquals((Object)"Saldhana", (Object)anil.getLastName());
        store.setAttribute(null, (IdentityType)anil, "QuestionTotal", new String[]{"2"});
        store.setAttribute(null, (IdentityType)anil, "Question1", new String[]{"What is favorite toy?"});
        store.setAttribute(null, (IdentityType)anil, "Question1Answer", new String[]{"Gum"});
        store.setAttribute(null, (IdentityType)anil, "Question2", new String[]{"What is favorite word?"});
        store.setAttribute(null, (IdentityType)anil, "Question2Answer", new String[]{"Hi"});
        anil = im.getUser("Anil Saldhana");
        Map attributes = anil.getAttributes();
        Assert.assertNotNull((Object)attributes);
        Assert.assertEquals((Object)"2", (Object)((String[])attributes.get("QuestionTotal"))[0]);
        Assert.assertEquals((Object)"What is favorite toy?", (Object)((String[])attributes.get("Question1"))[0]);
        Assert.assertEquals((Object)"Gum", (Object)((String[])attributes.get("Question1Answer"))[0]);
        Assert.assertEquals((Object)"What is favorite word?", (Object)((String[])attributes.get("Question2"))[0]);
        Assert.assertEquals((Object)"Hi", (Object)((String[])attributes.get("Question2Answer"))[0]);
    }

    private LDAPConfiguration getConfiguration() {
        String fqn = LDAPConfigurationBuilder.class.getName();
        LDAPConfiguration config = (LDAPConfiguration)IdentityStoreConfigurationBuilder.config((String)fqn);
        config.setBindDN(this.adminDN).setBindCredential(this.adminPW).setLdapURL("ldap://localhost:10389");
        config.setUserDNSuffix("ou=People,dc=jboss,dc=org").setRoleDNSuffix("ou=Roles,dc=jboss,dc=org");
        config.setGroupDNSuffix("ou=Groups,dc=jboss,dc=org");
        return config;
    }
}

