/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.ldap;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.GroupQuery;
import org.picketlink.test.idm.internal.ldap.AbstractLDAPIdentityManagerTestCase;

public class LDAPGroupQueryTestCase
extends AbstractLDAPIdentityManagerTestCase {
    private static final String GROUP_PARENT_NAME = "Test Parent Group";
    private static final String USER_NAME = "jduke";
    private static final String GROUP_NAME = "Test Group";
    private Group group;
    private User user;
    private Group parentGroup;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.group = this.getIdentityManager().getGroup(GROUP_NAME);
        this.user = this.getIdentityManager().getUser(USER_NAME);
        this.parentGroup = this.getIdentityManager().getGroup(GROUP_PARENT_NAME);
    }

    @Test
    public void testfindByName() throws Exception {
        GroupQuery query = this.createQuery();
        query.setName(this.group.getName());
        this.assertQueryResult(query);
        query.setName("Invalid");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindById() throws Exception {
        GroupQuery query = this.createQuery();
        query.setId(this.group.getId());
        this.assertQueryResult(query);
        query.setId("121");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindByRole() throws Exception {
        GroupQuery query = this.createQuery();
        query.setRole("Echo");
        this.assertQueryResult(query);
        query.setRole("TheDuke");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindByUser() throws Exception {
        GroupQuery query = this.createQuery();
        query.setId(this.group.getId());
        query.setRelatedUser(this.user);
        this.assertQueryResult(query);
        query.setRelatedUser("guest");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindByParentGroup() throws Exception {
        GroupQuery query = this.createQuery();
        query.setId(this.group.getId());
        query.setParentGroup(this.parentGroup);
        this.assertQueryResult(query);
        query.setParentGroup("Lonely Group");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    private void assertQueryResult(GroupQuery query) {
        List result = query.executeQuery();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)this.group.getId(), (String)((Group)result.get(0)).getId());
    }

    private GroupQuery createQuery() {
        return this.getIdentityManager().createGroupQuery();
    }
}

