/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.ldap;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.picketbox.test.ldap.AbstractLDAPTest;
import org.picketlink.idm.ldap.internal.LDAPConfiguration;
import org.picketlink.idm.ldap.internal.LDAPConfigurationBuilder;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPUser;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Membership;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.spi.IdentityStoreConfigurationBuilder;

public class LDAPIdentityStoreTestCase
extends AbstractLDAPTest {
    @Before
    public void setup() throws Exception {
        super.setup();
        this.importLDIF("ldap/users.ldif");
    }

    private LDAPConfiguration getConfiguration() {
        String fqn = LDAPConfigurationBuilder.class.getName();
        LDAPConfiguration config = (LDAPConfiguration)IdentityStoreConfigurationBuilder.config((String)fqn);
        config.setBindDN(this.adminDN).setBindCredential(this.adminPW).setLdapURL("ldap://localhost:10389");
        config.setUserDNSuffix("ou=People,dc=jboss,dc=org").setRoleDNSuffix("ou=Roles,dc=jboss,dc=org");
        config.setGroupDNSuffix("ou=Groups,dc=jboss,dc=org");
        return config;
    }

    @Test
    @Ignore
    public void testLDAPIdentityStore() throws Exception {
        LDAPIdentityStore store = new LDAPIdentityStore();
        store.setConfiguration(this.getConfiguration());
        LDAPUser user = new LDAPUser();
        user.setId("Anil Saldhana");
        store.createUser(null, (User)user);
        Assert.assertNotNull((Object)user);
        User anil = store.getUser(null, "Anil Saldhana");
        Assert.assertNotNull((Object)anil);
        Assert.assertEquals((Object)"Anil Saldhana", (Object)anil.getFullName());
        Assert.assertEquals((Object)"Anil", (Object)anil.getFirstName());
        Assert.assertEquals((Object)"Saldhana", (Object)anil.getLastName());
        Role role = store.createRole(null, "testRole");
        Assert.assertNotNull((Object)role);
        Assert.assertEquals((Object)"testRole", (Object)role.getName());
        Role ldapRole = store.getRole(null, "testRole");
        Assert.assertNotNull((Object)ldapRole);
        Assert.assertEquals((Object)"testRole", (Object)ldapRole.getName());
        Group ldapGroup = store.createGroup(null, "PicketBox Team", null);
        Assert.assertNotNull((Object)ldapGroup);
        Group retrievedLDAPGroup = store.getGroup(null, "PicketBox Team");
        Assert.assertNotNull((Object)retrievedLDAPGroup);
        Assert.assertNull((Object)retrievedLDAPGroup.getParentGroup());
        Group devGroup = store.createGroup(null, "Dev", ldapGroup);
        Assert.assertNotNull((Object)devGroup);
        Group retrievedDevGroup = store.getGroup(null, "Dev");
        Assert.assertNotNull((Object)retrievedDevGroup);
        Group parentOfDevGroup = retrievedDevGroup.getParentGroup();
        Assert.assertNotNull((Object)parentOfDevGroup);
        Assert.assertEquals((Object)"PicketBox Team", (Object)parentOfDevGroup.getName());
        Membership membership = store.createMembership(null, (IdentityType)anil, ldapGroup, ldapRole);
        Assert.assertNotNull((Object)membership);
        store.removeMembership(null, (IdentityType)anil, ldapGroup, ldapRole);
        store.removeUser(null, anil);
        store.removeRole(null, ldapRole);
        store.removeGroup(null, ldapGroup);
        store.removeGroup(null, devGroup);
        anil = store.getUser(null, "Anil Saldhana");
        Assert.assertNull((Object)anil);
        ldapRole = store.getRole(null, "testRole");
        Assert.assertNull((Object)ldapRole);
        Assert.assertNull((Object)store.getGroup(null, "Dev"));
        Assert.assertNull((Object)store.getGroup(null, "PicketBox Team"));
    }
}

