/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.ldap;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.picketbox.test.ldap.AbstractLDAPTest;
import org.picketlink.idm.internal.util.Base64;
import org.picketlink.idm.ldap.internal.LDAPConfiguration;
import org.picketlink.idm.ldap.internal.LDAPConfigurationBuilder;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPUser;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.User;

public class LDAPUserTestCase
extends AbstractLDAPTest {
    private static final String USER_DN_SUFFIX = "ou=People,dc=jboss,dc=org";
    private static final String USER_FULL_NAME = "Anil Saldhana";
    private static final String USER_FIRSTNAME = "Anil";
    private static final String USER_LASTNAME = "Saldhana";

    @Before
    public void setup() throws Exception {
        super.setup();
        this.importLDIF("ldap/users.ldif");
    }

    private LDAPConfiguration getConfiguration() {
        LDAPConfigurationBuilder builder = new LDAPConfigurationBuilder();
        LDAPConfiguration config = (LDAPConfiguration)builder.build();
        config.setBindDN(this.adminDN).setBindCredential(this.adminPW).setLdapURL("ldap://localhost:10389");
        config.setUserDNSuffix(USER_DN_SUFFIX).setRoleDNSuffix("ou=Roles,dc=jboss,dc=org");
        config.setGroupDNSuffix("ou=Groups,dc=jboss,dc=org");
        return config;
    }

    @Test
    @Ignore
    public void testLDAPIdentityStore() throws Exception {
        LDAPIdentityStore store = new LDAPIdentityStore();
        store.setConfiguration(this.getConfiguration());
        LDAPUser user = new LDAPUser();
        user.setId(USER_FULL_NAME);
        store.createUser(null, (User)user);
        Assert.assertNotNull((Object)user);
        User anil = store.getUser(null, USER_FULL_NAME);
        Assert.assertNotNull((Object)anil);
        Assert.assertEquals((Object)USER_FULL_NAME, (Object)anil.getFullName());
        Assert.assertEquals((Object)USER_FIRSTNAME, (Object)anil.getFirstName());
        Assert.assertEquals((Object)USER_LASTNAME, (Object)anil.getLastName());
        anil.setAttribute("telephoneNumber", "12345678");
        anil.setAttribute("QuestionTotal", "2");
        anil.setAttribute("Question1", "What is favorite toy?");
        anil.setAttribute("Question1Answer", "Gum");
        anil.setAttribute("Question2", "What is favorite word?");
        anil.setAttribute("Question2Answer", "Hi");
        InputStream bis = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("cert/servercert.txt");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(bis);
        bis.close();
        String encodedCert = Base64.encodeBytes((byte[])cert.getEncoded());
        anil.setAttribute("x509", encodedCert);
        Map attributes = store.getAttributes(null, (IdentityType)anil);
        Assert.assertNotNull((Object)attributes);
        Assert.assertEquals((Object)"12345678", (Object)((String[])attributes.get("telephoneNumber"))[0]);
        Assert.assertEquals((Object)"2", (Object)((String[])attributes.get("QuestionTotal"))[0]);
        Assert.assertEquals((Object)"What is favorite toy?", (Object)((String[])attributes.get("Question1"))[0]);
        Assert.assertEquals((Object)"Gum", (Object)((String[])attributes.get("Question1Answer"))[0]);
        Assert.assertEquals((Object)"What is favorite word?", (Object)((String[])attributes.get("Question2"))[0]);
        Assert.assertEquals((Object)"Hi", (Object)((String[])attributes.get("Question2Answer"))[0]);
        String loadedCert = ((String[])attributes.get("x509"))[0];
        byte[] certBytes = Base64.decode((String)loadedCert);
        cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBytes));
        Assert.assertNotNull((Object)cert);
        store.removeUser(null, anil);
        anil = store.getUser(null, USER_FULL_NAME);
        Assert.assertNull((Object)anil);
    }

    @Test
    public void testSimpleUserLdapStore() throws Exception {
        LDAPIdentityStore ldapIdentityStore = new LDAPIdentityStore();
        ldapIdentityStore.setConfiguration(this.getConfiguration());
        LDAPUser user = new LDAPUser();
        user.setId("abstractj");
        user.setFirstName("Bruno");
        user.setLastName("Oliveira");
        ldapIdentityStore.createUser(null, (User)user);
        User anil = ldapIdentityStore.getUser(null, "abstractj");
        Assert.assertNotNull((Object)anil);
        Assert.assertEquals((Object)"Bruno Oliveira", (Object)anil.getFullName());
        Assert.assertEquals((Object)"Bruno", (Object)anil.getFirstName());
        Assert.assertEquals((Object)"Oliveira", (Object)anil.getLastName());
        ldapIdentityStore.removeUser(null, anil);
        anil = ldapIdentityStore.getUser(null, "abstractj");
        Assert.assertNull((Object)anil);
    }

    @Test(expected=RuntimeException.class)
    public void testInvalidNewLDAPUserInstance() throws Exception {
        LDAPIdentityStore ldapIdentityStore = new LDAPIdentityStore();
        ldapIdentityStore.setConfiguration(this.getConfiguration());
        LDAPUser user = new LDAPUser();
        user.setFirstName("Bruno");
        user.setLastName("Oliveira");
        ldapIdentityStore.createUser(null, (User)user);
    }
}

