/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.file;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.test.idm.internal.file.AbstractFileIdentityTypeTestCase;

public class FileGroupTestCase
extends AbstractFileIdentityTypeTestCase {
    private static final String GROUP_NAME = "Administrators";
    private static final String GROUP_PARENT_NAME = "Company";

    @Test
    public void testGroupStore() throws Exception {
        IdentityManager identitymanager = this.getIdentityManager();
        Group parentGroup = identitymanager.createGroup(GROUP_PARENT_NAME, (Group)null);
        Group group = identitymanager.createGroup(GROUP_NAME, parentGroup);
        Assert.assertNotNull((Object)group);
        Assert.assertNotNull((Object)group.getKey());
        Assert.assertEquals((Object)GROUP_NAME, (Object)group.getName());
        this.testAddAttributes();
        this.testGetGroup();
        this.testRemoveGroup();
    }

    public void testGetGroup() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Group group = identityManager.getGroup(GROUP_NAME);
        Assert.assertNotNull((Object)group);
        Assert.assertNotNull((Object)group.getParentGroup());
        Assert.assertNotNull((Object)group.getKey());
        Assert.assertEquals((Object)GROUP_NAME, (Object)group.getName());
        Assert.assertEquals((Object)GROUP_PARENT_NAME, (Object)group.getParentGroup().getName());
        this.testRemoveAttributes();
    }

    public void testRemoveGroup() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Group group = identityManager.getGroup(GROUP_NAME);
        Assert.assertNotNull((Object)group);
        identityManager.removeGroup(group);
        group = identityManager.getGroup(GROUP_NAME);
        Assert.assertNull((Object)group);
    }

    @Override
    protected IdentityType getIdentityTypeFromDatabase(IdentityManager identityStore) {
        return identityStore.getGroup(GROUP_NAME);
    }
}

