/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.internal.DefaultIdentityManager;
import org.picketlink.idm.spi.IdentityStore;

public abstract class AbstractJPAIdentityManagerTestCase {
    protected static EntityManagerFactory emf;
    protected EntityManager entityManager;
    private DefaultIdentityManager identityManager;

    public static void onBeforeTests() throws Exception {
        emf = Persistence.createEntityManagerFactory((String)"jpa-identity-store-tests-pu");
    }

    public static void onAfterTests() throws Exception {
        emf.close();
    }

    public void onSetupTest() throws Exception {
        this.entityManager = emf.createEntityManager();
        this.entityManager.getTransaction().begin();
    }

    public void onFinishTest() throws Exception {
        this.entityManager.flush();
        this.entityManager.getTransaction().commit();
        this.entityManager.close();
    }

    protected IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = new DefaultIdentityManager();
            this.identityManager.setIdentityStore(this.createIdentityStore());
        }
        return this.identityManager;
    }

    protected IdentityStore createIdentityStore() {
        return null;
    }
}

