/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.jpa;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.RoleQuery;
import org.picketlink.test.idm.internal.jpa.AbstractJPAIdentityManagerTestCase;

public class JPARoleQueryTestCase
extends AbstractJPAIdentityManagerTestCase {
    private static final String USER_NAME = "theuser";
    private static final String GROUP_NAME = "Administrators";
    private static final String ROLE_NAME = "admin";
    private Group group;
    private User user;
    private Role role;

    @Override
    @Before
    public void onSetupTest() throws Exception {
        super.onSetupTest();
        this.loadRoles();
    }

    public void testfindByName() throws Exception {
        RoleQuery query = this.createRoleQuery();
        query.setName(this.role.getName());
        this.assertQueryResult(query);
        query.setName("Invalid");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    public void testfindByGroup() throws Exception {
        RoleQuery query = this.createRoleQuery();
        query.setName(this.role.getName());
        query.setGroup(this.group);
        this.assertQueryResult(query);
        query.setGroup("12121");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    public void testfindByAttributes() throws Exception {
        RoleQuery query = this.createRoleQuery();
        query.setName(this.role.getName());
        query.setAttributeFilter("attribute1", new String[]{"attributeValue1", "attributeValue12", "attributeValue123"});
        query.setAttributeFilter("attribute2", new String[]{"attributeValue2"});
        this.assertQueryResult(query);
        query.setAttributeFilter("Invalid", new String[]{"Invalid"});
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    private void loadRoles() {
        IdentityManager identityManager = this.getIdentityManager();
        this.group = identityManager.getGroup(GROUP_NAME);
        this.role = identityManager.getRole("admin1");
        this.user = identityManager.getUser(USER_NAME);
        if (this.role != null) {
            return;
        }
        this.group = identityManager.createGroup(GROUP_NAME, (Group)null);
        this.user = identityManager.createUser(USER_NAME);
        for (int i = 0; i < 10; ++i) {
            int index = i + 1;
            Role currentRole = identityManager.createRole(ROLE_NAME + index);
            if (this.role == null) {
                this.role = currentRole;
            }
            identityManager.grantRole(currentRole, (IdentityType)this.user, this.group);
            currentRole.setAttribute("attribute1", "attributeValue1");
            currentRole.setAttribute("attribute1", "attributeValue12");
            currentRole.setAttribute("attribute1", "attributeValue123");
            currentRole.setAttribute("attribute2", "attributeValue2");
        }
    }

    private void assertQueryResult(RoleQuery query) {
        List result = query.executeQuery();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)this.role.getName(), (String)((Role)result.get(0)).getName());
    }

    private RoleQuery createRoleQuery() {
        return this.getIdentityManager().createRoleQuery();
    }
}

