/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.ldap;

import java.util.List;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.RoleQuery;
import org.picketlink.test.idm.internal.ldap.AbstractLDAPIdentityManagerTestCase;

public class LDAPRoleQueryTestCase
extends AbstractLDAPIdentityManagerTestCase {
    private static final String USER_NAME = "jduke";
    private static final String GROUP_NAME = "Test Group";
    private static final String ROLE_NAME = "Echo";
    private Group group;
    private User user;
    private Role role;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.group = this.getIdentityManager().getGroup(GROUP_NAME);
        this.user = this.getIdentityManager().getUser(USER_NAME);
        this.role = this.getIdentityManager().getRole(ROLE_NAME);
    }

    @Test
    public void testfindByName() throws Exception {
        RoleQuery query = this.createRoleQuery();
        query.setName(this.role.getName());
        this.assertQueryResult(query);
        query.setName("Invalid");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindByGroup() throws Exception {
        RoleQuery query = this.createRoleQuery();
        query.setName(this.role.getName());
        query.setGroup(this.group);
        this.assertQueryResult(query);
        query.setGroup("Invalid");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindByOwner() throws Exception {
        RoleQuery query = this.createRoleQuery();
        query.setOwner((IdentityType)this.user);
        this.assertQueryResult(query);
        query.setOwner((IdentityType)this.getIdentityManager().getUser("guest"));
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    private void assertQueryResult(RoleQuery query) {
        List result = query.executeQuery();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)this.role.getName(), (String)((Role)result.get(0)).getName());
    }

    private RoleQuery createRoleQuery() {
        return this.getIdentityManager().createRoleQuery();
    }
}

