/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.mgr;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.picketbox.test.ldap.AbstractLDAPTest;
import org.picketlink.idm.credential.Credential;
import org.picketlink.idm.credential.PasswordCredential;
import org.picketlink.idm.credential.X509CertificateCredential;
import org.picketlink.idm.internal.DefaultIdentityManager;
import org.picketlink.idm.internal.util.Base64;
import org.picketlink.idm.ldap.internal.LDAPConfiguration;
import org.picketlink.idm.ldap.internal.LDAPConfigurationBuilder;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.UserQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreConfigurationBuilder;

public class DefaultLDAPIdentityManagerTestCase
extends AbstractLDAPTest {
    @Before
    public void setup() throws Exception {
        super.setup();
        this.importLDIF("ldap/users.ldif");
    }

    @Test
    @Ignore
    public void testDefaultIdentityManager() throws Exception {
        LDAPIdentityStore store = new LDAPIdentityStore();
        store.setConfiguration(this.getConfiguration());
        DefaultIdentityManager im = new DefaultIdentityManager();
        im.setIdentityStore((IdentityStore)store);
        User user = im.createUser("asaldhan");
        Assert.assertNotNull((Object)user);
        user.setFirstName("Anil");
        user.setLastName("Saldhana");
        User anil = im.getUser("asaldhan");
        Assert.assertNotNull((Object)anil);
        Assert.assertEquals((Object)"Anil Saldhana", (Object)anil.getFullName());
        Assert.assertEquals((Object)"Anil", (Object)anil.getFirstName());
        Assert.assertEquals((Object)"Saldhana", (Object)anil.getLastName());
        anil.setAttribute("QuestionTotal", "2");
        anil.setAttribute("Question1", "What is favorite toy?");
        anil.setAttribute("Question1Answer", "Gum");
        anil.setAttribute("Question2", "What is favorite word?");
        anil.setAttribute("Question2Answer", "Hi");
        InputStream bis = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("cert/servercert.txt");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(bis);
        bis.close();
        String encodedCert = Base64.encodeBytes((byte[])cert.getEncoded());
        anil.setAttribute("x509", encodedCert);
        im.updateCredential(anil, (Credential)new X509CertificateCredential(cert));
        anil = im.getUser("asaldhan");
        Map attributes = anil.getAttributes();
        Assert.assertNotNull((Object)attributes);
        String strCert = anil.getAttribute("usercertificate");
        byte[] decodedCert = Base64.decode((String)strCert);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(decodedCert);
        X509Certificate newCert = (X509Certificate)cf.generateCertificate(byteStream);
        Assert.assertNotNull((Object)newCert);
        Assert.assertEquals((Object)"2", (Object)((String[])attributes.get("QuestionTotal"))[0]);
        Assert.assertEquals((Object)"What is favorite toy?", (Object)((String[])attributes.get("Question1"))[0]);
        Assert.assertEquals((Object)"Gum", (Object)((String[])attributes.get("Question1Answer"))[0]);
        Assert.assertEquals((Object)"What is favorite word?", (Object)((String[])attributes.get("Question2"))[0]);
        Assert.assertEquals((Object)"Hi", (Object)((String[])attributes.get("Question2Answer"))[0]);
        String loadedCert = ((String[])attributes.get("x509"))[0];
        byte[] certBytes = Base64.decode((String)loadedCert);
        cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBytes));
        Assert.assertNotNull((Object)cert);
        String anilpass = "testpass";
        PasswordCredential pc = new PasswordCredential(anilpass);
        im.updateCredential(anil, (Credential)pc);
        Assert.assertTrue((boolean)im.validateCredential(anil, (Credential)pc));
        Assert.assertFalse((boolean)im.validateCredential(anil, (Credential)new PasswordCredential("BAD")));
        UserQuery query = im.createUserQuery().setAttributeFilter("QuestionTotal", new String[]{"2"});
        List returnedUsers = query.executeQuery();
        Assert.assertNotNull((Object)returnedUsers);
        Assert.assertEquals((long)1L, (long)returnedUsers.size());
        Role adminRole = im.createRole("admin");
        Group testGroup = im.createGroup("Fake Group");
        Group unusedGroup = im.createGroup("Unused Group");
        im.grantRole(adminRole, (IdentityType)anil, testGroup);
        Collection rolesByUser = im.getRoles((IdentityType)anil, null);
        Assert.assertNotNull((Object)rolesByUser);
        Assert.assertEquals((long)1L, (long)rolesByUser.size());
        Collection rolesByUserAndGroup = im.getRoles((IdentityType)anil, testGroup);
        Assert.assertNotNull((Object)rolesByUserAndGroup);
        Assert.assertEquals((long)1L, (long)rolesByUserAndGroup.size());
        Collection emptyRolesForUnusedGroup = im.getRoles((IdentityType)anil, unusedGroup);
        Assert.assertNotNull((Object)emptyRolesForUnusedGroup);
        Assert.assertTrue((boolean)emptyRolesForUnusedGroup.isEmpty());
        im.removeUser(anil);
        anil = im.getUser("asaldhan");
        Assert.assertNull((Object)anil);
    }

    private LDAPConfiguration getConfiguration() {
        String fqn = LDAPConfigurationBuilder.class.getName();
        LDAPConfiguration config = (LDAPConfiguration)IdentityStoreConfigurationBuilder.config((String)fqn);
        config.setBindDN(this.adminDN).setBindCredential(this.adminPW).setLdapURL("ldap://localhost:10389");
        config.setUserDNSuffix("ou=People,dc=jboss,dc=org").setRoleDNSuffix("ou=Roles,dc=jboss,dc=org");
        config.setGroupDNSuffix("ou=Groups,dc=jboss,dc=org");
        return config;
    }
}

