/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config.internal.resolver;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.picketlink.config.idm.ObjectType;
import org.picketlink.idm.config.internal.resolver.JavaPropertiesResolver;
import org.picketlink.idm.config.internal.resolver.ObjectTypeResolver;
import org.picketlink.idm.config.internal.resolver.PrimitivePropertyResolver;
import org.picketlink.idm.config.internal.resolver.PropertyResolver;

public class PropertyResolverMapper {
    private static final PropertyResolverMapper INSTANCE = PropertyResolverMapper.initInstance();
    private final PropertyResolver<Object> DEFAULT_PRIMITIVE_RESOLVER = new PrimitivePropertyResolver.PropertyEditorDelegateResolver();
    private final PropertyResolver<Object> DEFAULT_OBJECT_RESOLVER = new ObjectTypeResolver<Object>();
    private Map<Class<?>, PropertyResolver> propertyResolvers = new ConcurrentHashMap();

    public static PropertyResolverMapper getInstance() {
        return INSTANCE;
    }

    private static PropertyResolverMapper initInstance() {
        PropertyResolverMapper instance = new PropertyResolverMapper();
        instance.addPropertyResolver(String.class, new PrimitivePropertyResolver.StringResolver());
        instance.addPropertyResolver(Class.class, new PrimitivePropertyResolver.ClassResolver());
        instance.addPropertyResolver(Properties.class, new JavaPropertiesResolver());
        return instance;
    }

    private PropertyResolverMapper() {
    }

    public <V> void addPropertyResolver(Class<V> clazz, PropertyResolver<V> propertyResolver) {
        this.propertyResolvers.put(clazz, propertyResolver);
    }

    public <V> V resolveProperty(Object configurationType, Class<V> clazz) {
        PropertyResolver<Object> propertyResolver = this.propertyResolvers.get(clazz);
        if (propertyResolver == null) {
            if (configurationType instanceof String) {
                propertyResolver = this.DEFAULT_PRIMITIVE_RESOLVER;
            } else if (configurationType instanceof ObjectType) {
                propertyResolver = this.DEFAULT_OBJECT_RESOLVER;
            }
        }
        return propertyResolver.resolveProperty(configurationType, clazz);
    }
}

