/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import java.util.Date;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.internal.CredentialUtils;
import org.picketlink.idm.credential.internal.Password;
import org.picketlink.idm.credential.internal.UsernamePasswordCredentials;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.password.internal.SHASaltedPasswordEncoder;
import org.picketlink.idm.password.internal.SHASaltedPasswordStorage;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;

@SupportsCredentials(value={UsernamePasswordCredentials.class, Password.class})
public class PasswordCredentialHandler
implements CredentialHandler {
    public void validate(Credentials credentials, IdentityStore<?> identityStore) {
        SHASaltedPasswordStorage hash;
        CredentialStore store = this.validateCredentialStore(identityStore);
        if (!UsernamePasswordCredentials.class.isInstance(credentials)) {
            throw new IllegalArgumentException("Credentials class [" + credentials.getClass().getName() + "] not supported by this handler.");
        }
        UsernamePasswordCredentials usernamePassword = (UsernamePasswordCredentials)credentials;
        usernamePassword.setStatus(Credentials.Status.INVALID);
        Agent agent = identityStore.getAgent(usernamePassword.getUsername());
        if (agent != null && (hash = (SHASaltedPasswordStorage)store.retrieveCurrentCredential(agent, SHASaltedPasswordStorage.class)) != null) {
            if (!CredentialUtils.isCredentialExpired(hash)) {
                SHASaltedPasswordEncoder encoder = new SHASaltedPasswordEncoder(512);
                String encoded = encoder.encodePassword(hash.getSalt(), new String(usernamePassword.getPassword().getValue()));
                if (hash.getEncodedHash().equals(encoded)) {
                    usernamePassword.setStatus(Credentials.Status.VALID);
                    usernamePassword.setValidatedAgent(agent);
                }
            } else {
                usernamePassword.setStatus(Credentials.Status.EXPIRED);
            }
        }
    }

    public void update(Agent agent, Object credential, IdentityStore<?> identityStore, Date effectiveDate, Date expiryDate) {
        CredentialStore store = this.validateCredentialStore(identityStore);
        if (!Password.class.isInstance(credential)) {
            throw new IllegalArgumentException("Credential class [" + credential.getClass().getName() + "] not supported by this handler.");
        }
        Password password = (Password)credential;
        SHASaltedPasswordEncoder encoder = new SHASaltedPasswordEncoder(512);
        SHASaltedPasswordStorage hash = new SHASaltedPasswordStorage();
        hash.setEncodedHash(encoder.encodePassword(hash.getSalt(), new String(password.getValue())));
        hash.setEffectiveDate(effectiveDate);
        if (expiryDate != null) {
            hash.setExpiryDate(expiryDate);
        }
        store.storeCredential(agent, (CredentialStorage)hash);
    }

    private CredentialStore validateCredentialStore(IdentityStore<?> identityStore) {
        if (!CredentialStore.class.isInstance(identityStore)) {
            throw new IdentityManagementException("Provided IdentityStore [" + identityStore.getClass().getName() + "] is not an instance of CredentialStore.");
        }
        return (CredentialStore)identityStore;
    }
}

