/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import java.io.IOException;
import java.io.StringReader;
import java.security.Principal;
import java.util.Properties;
import org.picketlink.idm.credential.AbstractBaseCredentials;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.internal.X509Cert;

public class X509CertificateCredentials
extends AbstractBaseCredentials
implements Credentials {
    private X509Cert certificate;
    private String userName;

    public X509CertificateCredentials(X509Cert certificate) {
        this.certificate = certificate;
    }

    public X509Cert getCertificate() {
        return this.certificate;
    }

    public String getUsername() {
        if (this.userName == null) {
            Properties prop = new Properties();
            this.userName = this.getCertificatePrincipal().getName();
            try {
                prop.load(new StringReader(this.userName.replaceAll(",", "\n")));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.userName = prop.getProperty("CN");
        }
        return this.userName;
    }

    public X509CertificateCredentials setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public void invalidate() {
        this.certificate = null;
    }

    private Principal getCertificatePrincipal() {
        Principal certprincipal = this.certificate.getValue().getSubjectDN();
        if (certprincipal == null) {
            certprincipal = this.certificate.getValue().getIssuerDN();
        }
        return certprincipal;
    }
}

