/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import java.security.cert.CertificateEncodingException;
import java.util.Date;
import org.picketlink.common.util.Base64;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.internal.X509Cert;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.Stored;

public class X509CertificateStorage
implements CredentialStorage {
    private Date effectiveDate;
    private Date expiryDate;
    private String base64Cert;

    public X509CertificateStorage() {
    }

    public X509CertificateStorage(X509Cert credential) {
        try {
            this.base64Cert = Base64.encodeBytes((byte[])credential.getValue().getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new IdentityManagementException("Could not get Base64 representation for X509 Certificate.", (Throwable)e);
        }
    }

    @Stored
    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @Stored
    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    @Stored
    public String getBase64Cert() {
        return this.base64Cert;
    }

    public void setBase64Cert(String base64Cert) {
        this.base64Cert = base64Cert;
    }
}

