/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.HashMap;
import java.util.Map;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.file.internal.FileBasedIdentityStore;
import org.picketlink.idm.file.internal.FileIdentityStoreConfiguration;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.jpa.internal.JPAIdentityStoreConfiguration;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.StoreFactory;

public class DefaultStoreFactory
implements StoreFactory {
    private Map<Class<? extends IdentityStoreConfiguration>, Class<? extends IdentityStore<?>>> identityConfigMap = new HashMap();

    public DefaultStoreFactory() {
        this.identityConfigMap.put(JPAIdentityStoreConfiguration.class, JPAIdentityStore.class);
        this.identityConfigMap.put(LDAPIdentityStoreConfiguration.class, LDAPIdentityStore.class);
        this.identityConfigMap.put(FileIdentityStoreConfiguration.class, FileBasedIdentityStore.class);
    }

    public IdentityStore<?> createIdentityStore(IdentityStoreConfiguration config, IdentityStoreInvocationContext context) {
        for (Class<? extends IdentityStoreConfiguration> cc : this.identityConfigMap.keySet()) {
            if (!cc.isInstance(config)) continue;
            try {
                IdentityStore<?> identityStore = this.identityConfigMap.get(cc).newInstance();
                return identityStore;
            }
            catch (InstantiationException e) {
                throw new SecurityConfigurationException("Exception while creating new IdentityStore instance", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new SecurityConfigurationException("Exception while creating new IdentityStore instance", (Throwable)e);
            }
        }
        throw new IllegalArgumentException("The IdentityStoreConfiguration specified is not supported by this IdentityStoreFactory implementation");
    }

    public void mapIdentityConfiguration(Class<? extends IdentityStoreConfiguration> configClass, Class<? extends IdentityStore<?>> storeClass) {
        this.identityConfigMap.put(configClass, storeClass);
    }
}

