/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.event.AgentCreatedEvent;
import org.picketlink.idm.event.AgentDeletedEvent;
import org.picketlink.idm.event.AgentUpdatedEvent;
import org.picketlink.idm.jpa.annotations.PropertyType;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.jpa.internal.JPAIdentityStoreConfiguration;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.SimpleAgent;

public class AgentHandler
extends IdentityTypeHandler<Agent> {
    public AgentHandler(JPAIdentityStoreConfiguration config) {
        super(config);
        this.getSortParametersMapping().put(Agent.LOGIN_NAME, PropertyType.AGENT_LOGIN_NAME);
    }

    @Override
    protected void doPopulateIdentityInstance(Object toIdentity, Agent fromUser, JPAIdentityStore store) {
        this.getConfig().setModelPropertyValue(toIdentity, PropertyType.AGENT_LOGIN_NAME, fromUser.getLoginName(), true);
        this.getConfig().setModelPropertyValue(toIdentity, PropertyType.IDENTITY_PARTITION, store.lookupPartitionObject((Partition)store.getCurrentRealm()), true);
    }

    @Override
    protected AbstractBaseEvent raiseCreatedEvent(Agent fromIdentityType) {
        return new AgentCreatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseUpdatedEvent(Agent fromIdentityType) {
        return new AgentUpdatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseDeletedEvent(Agent fromIdentityType) {
        return new AgentDeletedEvent(fromIdentityType);
    }

    @Override
    protected Agent doCreateIdentityType(Object identity, JPAIdentityStore store) {
        String loginName = this.getConfig().getModelProperty(PropertyType.AGENT_LOGIN_NAME).getValue(identity).toString();
        SimpleAgent agent = new SimpleAgent(loginName);
        return agent;
    }

    @Override
    public List<Predicate> getPredicate(JPACriteriaQueryBuilder criteria, JPAIdentityStore store) {
        List<Predicate> predicates = super.getPredicate(criteria, store);
        CriteriaBuilder builder = criteria.getBuilder();
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(Agent.LOGIN_NAME);
        if (parameterValues != null) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.AGENT_LOGIN_NAME).getName()), parameterValues[0]));
        }
        return predicates;
    }

    @Override
    public void validate(Agent agent, JPAIdentityStore store) {
        if (agent.getLoginName() == null) {
            throw new IdentityManagementException("No login name was provided.");
        }
        if (store.getAgent(agent.getLoginName()) != null) {
            throw new IdentityManagementException("Agent already exists with the given loginName [" + agent.getLoginName() + "] for the given Realm [" + store.getCurrentRealm().getName() + "]");
        }
    }
}

