/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.util.Base64;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.Stored;
import org.picketlink.idm.jpa.annotations.PropertyType;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.jpa.internal.JPAIdentityStoreConfiguration;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

public class JPACredentialStore
implements CredentialStore {
    private JPAIdentityStore identityStore;

    public JPACredentialStore(JPAIdentityStore identityStore) {
        this.identityStore = identityStore;
    }

    public void storeCredential(Agent agent, CredentialStorage storage) {
        this.checkCredentialClassProvided();
        Property<Object> expiryProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_EXPIRY_DATE);
        Object newCredential = null;
        try {
            newCredential = this.getConfig().getCredentialClass().newInstance();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Could not instantiate credential class [" + this.getConfig().getCredentialClass().getName() + "].", (Throwable)e);
        }
        Date effectiveDate = storage.getEffectiveDate();
        if (effectiveDate == null) {
            effectiveDate = new Date();
        }
        Object agentInstance = this.identityStore.lookupIdentityObjectById(agent.getId());
        Property<Object> identityTypeProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_IDENTITY);
        Property<Object> typeProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_TYPE);
        Property<Object> effectiveProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_EFFECTIVE_DATE);
        identityTypeProperty.setValue(newCredential, agentInstance);
        typeProperty.setValue(newCredential, (Object)storage.getClass().getName());
        effectiveProperty.setValue(newCredential, (Object)effectiveDate);
        expiryProperty.setValue(newCredential, (Object)storage.getExpiryDate());
        EntityManager em = this.getEntityManager();
        em.persist(newCredential);
        List annotatedTypes = PropertyQueries.createQuery(storage.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(Stored.class)).getResultList();
        Property<Object> attributeName = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_NAME);
        Property<Object> attributeValue = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_VALUE);
        Property<Object> attributeCredential = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_CREDENTIAL);
        for (Property property : annotatedTypes) {
            Object newCredentialAttribute = null;
            try {
                newCredentialAttribute = this.getConfig().getCredentialAttributeClass().newInstance();
            }
            catch (Exception e) {
                throw new IdentityManagementException("Could not instantiate credential attribute class [" + this.getConfig().getCredentialAttributeClass().getName() + "].", (Throwable)e);
            }
            attributeName.setValue(newCredentialAttribute, (Object)property.getName());
            attributeValue.setValue(newCredentialAttribute, (Object)Base64.encodeObject((Serializable)((Serializable)property.getValue((Object)storage))));
            attributeCredential.setValue(newCredentialAttribute, newCredential);
            em.persist(newCredentialAttribute);
        }
        em.flush();
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(Agent agent, Class<T> storageClass) {
        this.checkCredentialClassProvided();
        Property<Object> identityTypeProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_IDENTITY);
        Property<Object> typeProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_TYPE);
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getCredentialClass());
        Root root = criteria.from(this.getConfig().getCredentialClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Object agentInstance = this.identityStore.lookupIdentityObjectById(agent.getId());
        predicates.add(builder.equal((Expression)root.get(identityTypeProperty.getName()), agentInstance));
        predicates.add(builder.equal((Expression)root.get(typeProperty.getName()), (Object)storageClass.getName()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List result = em.createQuery(criteria).getResultList();
        ArrayList<T> storages = new ArrayList<T>();
        for (Object object : result) {
            storages.add(this.convertToCredentialStorage(object, storageClass));
        }
        return storages;
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(Agent agent, Class<T> storageClass) {
        this.checkCredentialClassProvided();
        return this.convertToCredentialStorage(this.retrieveLastCredentialEntity(agent, storageClass), storageClass);
    }

    protected void removeCredentials(Object object) {
        if (this.getConfig().getCredentialClass() != null) {
            EntityManager em = this.getEntityManager();
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(this.getConfig().getCredentialClass());
            Root root = criteria.from(this.getConfig().getCredentialClass());
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.CREDENTIAL_IDENTITY).getName()), object));
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            List results = em.createQuery(criteria).getResultList();
            for (Object credential : results) {
                CriteriaQuery attributeCriteria = builder.createQuery(this.getConfig().getCredentialAttributeClass());
                Root attributeRoot = attributeCriteria.from(this.getConfig().getCredentialAttributeClass());
                ArrayList<Predicate> attributePredicates = new ArrayList<Predicate>();
                Property<Object> attributeCredential = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_CREDENTIAL);
                attributePredicates.add(builder.equal((Expression)attributeRoot.get(attributeCredential.getName()), credential));
                List attributes = em.createQuery(attributeCriteria).getResultList();
                for (Object attribute : attributes) {
                    em.remove(attribute);
                }
                em.remove(credential);
            }
        }
    }

    public void validateCredentials(Credentials credentials) {
        CredentialHandler handler = this.getContext().getCredentialValidator(credentials.getClass(), (IdentityStore)this.identityStore);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for validating Credentials of type [" + credentials.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.validate(credentials, (IdentityStore)this.identityStore);
    }

    public void updateCredential(Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        CredentialHandler handler = this.getContext().getCredentialUpdater(credential.getClass(), (IdentityStore)this.identityStore);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for updating Credentials of type [" + credential.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.update(agent, credential, (IdentityStore)this.identityStore, effectiveDate, expiryDate);
    }

    private IdentityStoreInvocationContext getContext() {
        return this.identityStore.getContext();
    }

    private <T extends CredentialStorage> T convertToCredentialStorage(Object instance, Class<T> storageClass) {
        CredentialStorage storage = null;
        if (instance != null) {
            try {
                storage = (CredentialStorage)storageClass.newInstance();
            }
            catch (Exception e) {
                throw new IdentityManagementException("Could not instantiate storage class [" + storageClass.getName() + "].", (Throwable)e);
            }
            Property<Object> effectiveProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_EFFECTIVE_DATE);
            Property<Object> expiryProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_EXPIRY_DATE);
            List effectiveDateProperty = PropertyQueries.createQuery(storageClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{"effectiveDate"})).getResultList();
            ((Property)effectiveDateProperty.get(0)).setValue((Object)storage, effectiveProperty.getValue(instance));
            List expiryDateProperty = PropertyQueries.createQuery(storageClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{"expiryDate"})).getResultList();
            ((Property)expiryDateProperty.get(0)).setValue((Object)storage, expiryProperty.getValue(instance));
            EntityManager em = this.getEntityManager();
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery attributeCriteria = builder.createQuery(this.getConfig().getCredentialAttributeClass());
            Root attributeRoot = attributeCriteria.from(this.getConfig().getCredentialAttributeClass());
            ArrayList<Predicate> attributePredicates = new ArrayList<Predicate>();
            Property<Object> attributeCredential = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_CREDENTIAL);
            attributePredicates.add(builder.equal((Expression)attributeRoot.get(attributeCredential.getName()), instance));
            attributeCriteria.where(attributePredicates.toArray(new Predicate[attributePredicates.size()]));
            List attributes = em.createQuery(attributeCriteria).getResultList();
            Property<Object> attributeName = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_NAME);
            Property<Object> attributeValue = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_VALUE);
            for (Object attribute : attributes) {
                String name = attributeName.getValue(attribute).toString();
                String value = attributeValue.getValue(attribute).toString();
                List annotatedTypes = PropertyQueries.createQuery(storageClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{name})).getResultList();
                if (annotatedTypes.isEmpty()) {
                    throw new IdentityManagementException("Could not find property [" + attributeName.getName() + "] on CredentialStorage [" + storageClass.getName() + "].");
                }
                if (annotatedTypes.size() > 1) {
                    throw new IdentityManagementException("Ambiguos property [" + attributeName.getName() + "] on CredentialStorage [" + storageClass.getName() + "].");
                }
                Property property = (Property)annotatedTypes.get(0);
                property.setValue((Object)storage, Base64.decodeToObject((String)value));
            }
        }
        return (T)storage;
    }

    private <T> Object retrieveLastCredentialEntity(Agent agent, Class<T> storageClass) {
        Property<Object> identityTypeProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_IDENTITY);
        Property<Object> typeProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_TYPE);
        Property<Object> effectiveProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_EFFECTIVE_DATE);
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getCredentialClass());
        Root root = criteria.from(this.getConfig().getCredentialClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Object agentInstance = this.identityStore.lookupIdentityObjectById(agent.getId());
        predicates.add(builder.equal((Expression)root.get(identityTypeProperty.getName()), agentInstance));
        predicates.add(builder.equal((Expression)root.get(typeProperty.getName()), (Object)storageClass.getName()));
        Predicate conjunction = builder.conjunction();
        conjunction.getExpressions().add(builder.lessThanOrEqualTo((Expression)root.get(effectiveProperty.getName()), (Comparable)new Date()));
        predicates.add(conjunction);
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        criteria.orderBy(new Order[]{builder.desc((Expression)root.get(effectiveProperty.getName()))});
        Object lastCredential = null;
        try {
            List result = em.createQuery(criteria).getResultList();
            if (!result.isEmpty()) {
                lastCredential = result.get(0);
            }
        }
        catch (NoResultException ignore) {
        }
        catch (Exception e) {
            throw new IdentityManagementException("Could not query credentials.", (Throwable)e);
        }
        return lastCredential;
    }

    private JPAIdentityStoreConfiguration getConfig() {
        return this.identityStore.getConfig();
    }

    private void checkCredentialClassProvided() {
        if (this.getConfig().getCredentialClass() == null) {
            throw new IdentityManagementException("No class Entity class provided to store credentials.");
        }
    }

    private EntityManager getEntityManager() {
        return this.identityStore.getEntityManager();
    }
}

