/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.PropertyQuery;
import org.picketlink.common.properties.query.TypedPropertyCriteria;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.jpa.annotations.IDMAttribute;
import org.picketlink.idm.jpa.annotations.IDMProperty;
import org.picketlink.idm.jpa.annotations.PropertyType;
import org.picketlink.idm.jpa.internal.AgentHandler;
import org.picketlink.idm.jpa.internal.GroupHandler;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.RoleHandler;
import org.picketlink.idm.jpa.internal.UserHandler;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;

public class JPAIdentityStoreConfiguration
extends IdentityStoreConfiguration {
    private static final String DEFAULT_USER_IDENTITY_DISCRIMINATOR = "USER";
    private static final String DEFAULT_ROLE_IDENTITY_DISCRIMINATOR = "ROLE";
    private static final String DEFAULT_GROUP_IDENTITY_DISCRIMINATOR = "GROUP";
    private static final String DEFAULT_AGENT_IDENTITY_DISCRIMINATOR = "AGENT";
    private String identityTypeAgent = "AGENT";
    private String identityTypeUser = "USER";
    private String identityTypeRole = "ROLE";
    private String identityTypeGroup = "GROUP";
    private Map<String, IdentityTypeHandler<? extends IdentityType>> identityTypeStores = new HashMap<String, IdentityTypeHandler<? extends IdentityType>>();
    private IdentityStoreConfiguration.FeatureSet featureSet = new IdentityStoreConfiguration.FeatureSet((IdentityStoreConfiguration)this);
    private Map<PropertyType, Property<Object>> modelProperties = new HashMap<PropertyType, Property<Object>>();
    private Map<String, MappedAttribute> attributeProperties = new HashMap<String, MappedAttribute>();
    private Class<?> identityClass;
    private Class<?> attributeClass;
    private Class<?> credentialClass;
    private Class<?> credentialAttributeClass;
    private Class<?> relationshipClass;
    private Class<?> relationshipIdentityClass;
    private Class<?> relationshipAttributeClass;
    private Class<?> partitionClass;

    public Class<?> getIdentityClass() {
        return this.identityClass;
    }

    public void setIdentityClass(Class<?> identityClass) {
        this.identityClass = identityClass;
    }

    public Class<?> getCredentialClass() {
        return this.credentialClass;
    }

    public void setCredentialClass(Class<?> credentialClass) {
        this.credentialClass = credentialClass;
    }

    public Class<?> getCredentialAttributeClass() {
        return this.credentialAttributeClass;
    }

    public void setCredentialAttributeClass(Class<?> credentialAttributeClass) {
        this.credentialAttributeClass = credentialAttributeClass;
    }

    public Class<?> getRelationshipClass() {
        return this.relationshipClass;
    }

    public Class<?> getPartitionClass() {
        return this.partitionClass;
    }

    public void setRelationshipClass(Class<?> relationshipClass) {
        this.relationshipClass = relationshipClass;
    }

    public void setPartitionClass(Class<?> partitionClass) {
        this.partitionClass = partitionClass;
    }

    public Class<?> getRelationshipIdentityClass() {
        return this.relationshipIdentityClass;
    }

    public void setRelationshipIdentityClass(Class<?> relationshipIdentityClass) {
        this.relationshipIdentityClass = relationshipIdentityClass;
    }

    public Class<?> getRelationshipAttributeClass() {
        return this.relationshipAttributeClass;
    }

    public void setRelationshipAttributeClass(Class<?> relationshipAttributeClass) {
        this.relationshipAttributeClass = relationshipAttributeClass;
    }

    public Class<?> getAttributeClass() {
        return this.attributeClass;
    }

    public void setAttributeClass(Class<?> attributeClass) {
        this.attributeClass = attributeClass;
    }

    public boolean isConfigured() {
        return this.identityClass != null;
    }

    protected void configureModelProperty(PropertyType propertyType, Class<?> targetClass, Class<?> propertyClass, String ... possibleNames) {
        this.configureModelProperty(propertyType, targetClass, propertyClass, false, possibleNames);
    }

    protected void configureModelProperty(PropertyType propertyType, Class<?> targetClass, Class<?> propertyClass, boolean optional, String ... possibleNames) {
        List props;
        PropertyQuery query = PropertyQueries.createQuery(targetClass);
        if (propertyType != null) {
            query.addCriteria((PropertyCriteria)new PropertyTypeCriteria(propertyType));
        }
        if (propertyClass != null) {
            query.addCriteria((PropertyCriteria)new TypedPropertyCriteria(propertyClass));
        }
        if ((props = query.getResultList()).size() == 1) {
            this.modelProperties.put(propertyType, (Property<Object>)props.get(0));
        } else {
            Property<Object> p;
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous " + propertyType.name() + " property in identity class [" + targetClass.getName() + "]");
            }
            if (possibleNames != null && possibleNames.length > 0 && (p = this.findNamedProperty(targetClass, possibleNames)) != null) {
                this.modelProperties.put(propertyType, p);
            }
            if (!optional) {
                throw new SecurityConfigurationException("Error configuring JPAIdentityStore - no " + propertyType.name() + " property found in identity class [" + targetClass.getName() + "]");
            }
        }
    }

    protected Property<Object> findNamedProperty(Class<?> targetClass, String ... allowedNames) {
        List props = PropertyQueries.createQuery(targetClass).addCriteria((PropertyCriteria)new TypedPropertyCriteria(String.class)).addCriteria((PropertyCriteria)new NamedPropertyCriteria(allowedNames)).getResultList();
        for (String name : allowedNames) {
            for (Property prop : props) {
                if (!name.equals(prop.getName())) continue;
                return prop;
            }
        }
        return null;
    }

    public Property<Object> getModelProperty(PropertyType propertyType) {
        return this.modelProperties.get(propertyType);
    }

    protected <P> P getModelPropertyValue(Class<P> propertyClass, Object instance, PropertyType propertyType) {
        Property<Object> property = this.getModelProperty(propertyType);
        return (P)(property == null ? null : property.getValue(instance));
    }

    protected void setModelPropertyValue(Object instance, PropertyType propertyType, Object value) {
        this.setModelPropertyValue(instance, propertyType, value, false);
    }

    protected void setModelPropertyValue(Object instance, PropertyType propertyType, Object value, boolean required) {
        if (this.isModelPropertySet(propertyType)) {
            this.getModelProperty(propertyType).setValue(instance, value);
        } else if (required) {
            throw new IdentityManagementException("Model property [" + propertyType.name() + "] has not been configured.");
        }
    }

    public boolean isModelPropertySet(PropertyType propertyType) {
        return this.modelProperties.containsKey(propertyType);
    }

    public Map<String, MappedAttribute> getAttributeProperties() {
        return this.attributeProperties;
    }

    public IdentityStoreConfiguration.FeatureSet getFeatureSet() {
        return this.featureSet;
    }

    public void init() throws SecurityConfigurationException {
        if (this.identityClass == null) {
            throw new SecurityConfigurationException("Error initializing JpaIdentityStore - identityClass not set");
        }
        this.configureIdentityTypeHandlers();
        this.configureIdentity();
        this.configurePartitions();
        this.configureUserProperties();
        this.configureRelationships();
        this.configureAttributes();
        this.configureCredentials();
        this.featureSet.addSupportedFeature(IdentityStoreConfiguration.Feature.all);
        this.featureSet.addSupportedRelationship(Relationship.class);
    }

    private void configureIdentityTypeHandlers() {
        this.identityTypeStores.put(this.getIdentityTypeDiscriminator(User.class), new UserHandler(this));
        this.identityTypeStores.put(this.getIdentityTypeDiscriminator(Agent.class), new AgentHandler(this));
        this.identityTypeStores.put(this.getIdentityTypeDiscriminator(Role.class), new RoleHandler(this));
        this.identityTypeStores.put(this.getIdentityTypeDiscriminator(Group.class), new GroupHandler(this));
    }

    private void configureCredentials() {
        if (this.credentialClass != null) {
            this.configureModelProperty(PropertyType.CREDENTIAL_TYPE, this.credentialClass, null, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_VALUE, this.credentialClass, null, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_IDENTITY, this.credentialClass, null, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_EFFECTIVE_DATE, this.credentialClass, null, new String[0]);
            this.configureModelProperty(PropertyType.CREDENTIAL_EXPIRY_DATE, this.credentialClass, null, new String[0]);
            if (this.credentialAttributeClass != null) {
                this.configureModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_NAME, this.credentialAttributeClass, String.class, new String[0]);
                this.configureModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_VALUE, this.credentialAttributeClass, null, new String[0]);
                this.configureModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_CREDENTIAL, this.credentialAttributeClass, this.credentialClass, new String[0]);
            }
        }
    }

    protected void configureIdentity() throws SecurityConfigurationException {
        this.configureModelProperty(PropertyType.IDENTITY_DISCRIMINATOR, this.identityClass, null, "discriminator", "identityType", "identityTypeName", "typeName", "type");
        this.configureModelProperty(PropertyType.IDENTITY_ID, this.identityClass, null, "id", "identifier");
        this.configureModelProperty(PropertyType.IDENTITY_NAME, this.identityClass, null, "name");
        this.configureModelProperty(PropertyType.GROUP_PARENT, this.identityClass, null, "parentGroup", "parent");
        this.configureModelProperty(PropertyType.GROUP_PATH, this.identityClass, null, "groupPath", "path");
        this.configureModelProperty(PropertyType.IDENTITY_ENABLED, this.identityClass, null, "enabled", "active");
        this.configureModelProperty(PropertyType.IDENTITY_CREATION_DATE, this.identityClass, null, false, "created", "creationDate");
        this.configureModelProperty(PropertyType.IDENTITY_EXPIRY_DATE, this.identityClass, null, false, "expires", "expiryDate");
        this.configureModelProperty(PropertyType.IDENTITY_PARTITION, this.identityClass, null, false, "partition");
        this.configureModelProperty(PropertyType.AGENT_LOGIN_NAME, this.identityClass, null, "loginName", "login");
    }

    protected void configurePartitions() {
        if (this.partitionClass == null) {
            return;
        }
        this.configureModelProperty(PropertyType.PARTITION_ID, this.partitionClass, null, "id", "id");
        this.configureModelProperty(PropertyType.PARTITION_TYPE, this.partitionClass, null, "type", "partitionType");
        this.configureModelProperty(PropertyType.PARTITION_NAME, this.partitionClass, null, "name");
        this.configureModelProperty(PropertyType.PARTITION_PARENT, this.partitionClass, null, "parent");
    }

    protected void configureUserProperties() throws SecurityConfigurationException {
        this.configureModelProperty(PropertyType.USER_FIRST_NAME, this.identityClass, null, false, "firstName");
        this.configureModelProperty(PropertyType.USER_LAST_NAME, this.identityClass, null, false, "lastName");
        this.configureModelProperty(PropertyType.USER_EMAIL, this.identityClass, null, false, "email");
    }

    protected void configureRelationships() throws SecurityConfigurationException {
        if (this.relationshipClass == null) {
            return;
        }
        if (this.relationshipIdentityClass == null || this.relationshipAttributeClass == null) {
            throw new SecurityConfigurationException("Invalid JPAIdentityStoreConfiguration - Both relationshipIdentityClass and relationshipAttributeClass properties must be set if relationships are configured");
        }
        this.configureModelProperty(PropertyType.RELATIONSHIP_ID, this.relationshipClass, null, "id");
        this.configureModelProperty(PropertyType.RELATIONSHIP_CLASS, this.relationshipClass, null, "relationshipClass");
        this.configureModelProperty(PropertyType.RELATIONSHIP_IDENTITY, this.relationshipIdentityClass, null, "identity");
        this.configureModelProperty(PropertyType.RELATIONSHIP_DESCRIPTOR, this.relationshipIdentityClass, null, "descriptor");
        this.configureModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP, this.relationshipIdentityClass, this.relationshipClass, new String[0]);
        this.configureModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_NAME, this.relationshipAttributeClass, null, "attributeName", "name");
        this.configureModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_VALUE, this.relationshipAttributeClass, null, "attributeValue", "value");
        this.configureModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_RELATIONSHIP, this.relationshipAttributeClass, null, new String[0]);
    }

    protected void configureAttributes() throws SecurityConfigurationException {
        if (this.attributeClass == null) {
            return;
        }
        this.configureModelProperty(PropertyType.ATTRIBUTE_IDENTITY, this.attributeClass, this.identityClass, new String[0]);
        this.configureModelProperty(PropertyType.ATTRIBUTE_NAME, this.attributeClass, null, "attributeName", "name");
        this.configureModelProperty(PropertyType.ATTRIBUTE_TYPE, this.attributeClass, null, "attributeType", "type");
        this.configureModelProperty(PropertyType.ATTRIBUTE_VALUE, this.attributeClass, null, "attributeValue", "value");
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(IDMAttribute.class)).getResultList();
        for (Property p : props) {
            String attribName = p.getAnnotatedElement().getAnnotation(IDMAttribute.class).name();
            if (this.attributeProperties.containsKey(attribName)) {
                Property<Object> other = this.attributeProperties.get(attribName).getAttributeProperty();
                throw new SecurityConfigurationException("Multiple properties defined for attribute [" + attribName + "] - " + "Property: " + other.getDeclaringClass().getName() + "." + other.getAnnotatedElement().toString() + ", Property: " + p.getDeclaringClass().getName() + "." + p.getAnnotatedElement().toString());
            }
            this.attributeProperties.put(attribName, new MappedAttribute(null, (Property<Object>)p));
        }
    }

    public String getIdentityTypeUser() {
        return this.identityTypeUser;
    }

    public void setIdentityTypeUser(String identityTypeUser) {
        this.identityTypeUser = identityTypeUser;
    }

    public String getIdentityTypeGroup() {
        return this.identityTypeGroup;
    }

    public void setIdentityTypeGroup(String identityTypeGroup) {
        this.identityTypeGroup = identityTypeGroup;
    }

    public String getIdentityTypeRole() {
        return this.identityTypeRole;
    }

    public void setIdentityTypeRole(String identityTypeRole) {
        this.identityTypeRole = identityTypeRole;
    }

    public String getIdentityTypeAgent() {
        return this.identityTypeAgent;
    }

    public void setIdentityTypeAgent(String identityTypeAgent) {
        this.identityTypeAgent = identityTypeAgent;
    }

    protected String getIdentityTypeDiscriminator(Class<? extends IdentityType> identityType) {
        String discriminator = null;
        if (User.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeUser();
        } else if (Agent.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeAgent();
        } else if (Role.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeRole();
        } else if (Group.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeGroup();
        } else if (Agent.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeAgent();
        } else {
            throw new IdentityManagementException("No discriminator could be determined for type [" + identityType.getClass() + "]");
        }
        return discriminator;
    }

    public Map<String, IdentityTypeHandler<? extends IdentityType>> getIdentityTypeStores() {
        return this.identityTypeStores;
    }

    IdentityTypeHandler<IdentityType> getHandler(Class<? extends IdentityType> identityTypeClass) {
        IdentityTypeHandler<IdentityType> identityTypeManager = this.getIdentityTypeStores().get(this.getIdentityDiscriminator(identityTypeClass));
        return identityTypeManager;
    }

    IdentityTypeHandler<IdentityType> getHandler(String discriminator) {
        return this.getIdentityTypeStores().get(discriminator);
    }

    String getIdentityDiscriminator(Class<? extends IdentityType> identityType) {
        return this.getIdentityTypeDiscriminator(identityType);
    }

    public class MappedAttribute {
        private Property<Object> identityProperty;
        private Property<Object> attributeProperty;

        public MappedAttribute(Property<Object> identityProperty, Property<Object> attributeProperty) {
            this.identityProperty = identityProperty;
            this.attributeProperty = attributeProperty;
        }

        public Property<Object> getIdentityProperty() {
            return this.identityProperty;
        }

        public Property<Object> getAttributeProperty() {
            return this.attributeProperty;
        }
    }

    public class PropertyTypeCriteria
    implements PropertyCriteria {
        private PropertyType pt;

        public PropertyTypeCriteria(PropertyType pt) {
            this.pt = pt;
        }

        public boolean fieldMatches(Field f) {
            return f.isAnnotationPresent(IDMProperty.class) && f.getAnnotation(IDMProperty.class).value().equals((Object)this.pt);
        }

        public boolean methodMatches(Method m) {
            return m.isAnnotationPresent(IDMProperty.class) && m.getAnnotation(IDMProperty.class).value().equals((Object)this.pt);
        }
    }
}

