/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.query.internal;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.spi.IdentityStore;

public class DefaultRelationshipQuery<T extends Relationship>
implements RelationshipQuery<T> {
    private Map<QueryParameter, Object[]> parameters = new LinkedHashMap<QueryParameter, Object[]>();
    private IdentityStore<?> identityStore;
    private Class<T> relationshipType;
    private int offset;
    private int limit;

    public DefaultRelationshipQuery(Class<T> relationshipType, IdentityStore<?> identityStore) {
        this.identityStore = identityStore;
        this.relationshipType = relationshipType;
    }

    public RelationshipQuery<T> setParameter(QueryParameter param, Object ... value) {
        this.parameters.put(param, value);
        return this;
    }

    public Class<T> getRelationshipType() {
        return this.relationshipType;
    }

    public Map<QueryParameter, Object[]> getParameters() {
        return this.parameters;
    }

    public Object[] getParameter(QueryParameter queryParameter) {
        return this.parameters.get(queryParameter);
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public List<T> getResultList() {
        return this.identityStore.fetchQueryResults((RelationshipQuery)this);
    }

    public int getResultCount() {
        return this.identityStore.countQueryResults((RelationshipQuery)this);
    }

    public RelationshipQuery<T> setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public RelationshipQuery<T> setLimit(int limit) {
        this.limit = limit;
        return this;
    }
}

