/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleAgent;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;

public class AbstractIdentityManagerTestCase {
    private IdentityManager identityManager;

    public IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            throw new RuntimeException("Identity Manager is not set.");
        }
        return this.identityManager;
    }

    public void setIdentityManager(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    protected User createUser(String userName) {
        User user = this.getIdentityManager().getUser(userName);
        if (user != null) {
            this.getIdentityManager().remove((IdentityType)user);
        }
        user = new SimpleUser(userName);
        this.getIdentityManager().add((IdentityType)user);
        return user;
    }

    protected User getUser(String userName) {
        return this.getIdentityManager().getUser(userName);
    }

    protected Agent createAgent(String loginName) {
        Agent agent = this.getIdentityManager().getAgent(loginName);
        if (agent != null) {
            this.getIdentityManager().remove((IdentityType)agent);
            agent = null;
        }
        agent = new SimpleAgent(loginName);
        this.getIdentityManager().add((IdentityType)agent);
        return agent;
    }

    protected Agent getAgent(String loginName) {
        return this.getIdentityManager().getAgent(loginName);
    }

    protected Role createRole(String name) {
        Role role = this.getIdentityManager().getRole(name);
        if (role != null) {
            this.getIdentityManager().remove((IdentityType)role);
            role = null;
        }
        role = new SimpleRole(name);
        this.getIdentityManager().add((IdentityType)role);
        return role;
    }

    protected Role getRole(String name) {
        return this.getIdentityManager().getRole(name);
    }

    protected Group createGroup(String name, String parentGroupName) {
        Group group;
        Group parentGroup = this.getIdentityManager().getGroup(parentGroupName);
        if (parentGroup != null && parentGroupName != null) {
            this.getIdentityManager().remove((IdentityType)parentGroup);
            parentGroup = null;
        }
        if (parentGroup == null && parentGroupName != null) {
            parentGroup = new SimpleGroup(parentGroupName);
            this.getIdentityManager().add((IdentityType)parentGroup);
        }
        if ((group = this.getIdentityManager().getGroup(name)) != null) {
            this.getIdentityManager().remove((IdentityType)group);
            group = null;
        }
        if (group == null) {
            group = parentGroupName == null ? new SimpleGroup(name) : new SimpleGroup(name, parentGroup);
            this.getIdentityManager().add((IdentityType)group);
        }
        return group;
    }

    protected Group getGroup(String name) {
        return this.getIdentityManager().getGroup(name);
    }
}

