/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public abstract class AbstractIdentityTypeTestCase<T extends IdentityType>
extends AbstractIdentityManagerTestCase {
    @Test
    public void testDisable() throws Exception {
        T enabledIdentityType = this.createIdentityType();
        junit.framework.Assert.assertTrue((boolean)enabledIdentityType.isEnabled());
        enabledIdentityType.setEnabled(false);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update(enabledIdentityType);
        T disabledIdentityType = this.getIdentityType();
        junit.framework.Assert.assertFalse((boolean)disabledIdentityType.isEnabled());
        disabledIdentityType.setEnabled(true);
        identityManager.update(disabledIdentityType);
        enabledIdentityType = this.getIdentityType();
        junit.framework.Assert.assertTrue((boolean)enabledIdentityType.isEnabled());
    }

    @Test
    public void testLookupById() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        T identityType = this.createIdentityType();
        IdentityType lookedUpIdentityType = identityManager.lookupIdentityById(identityType.getClass(), identityType.getId());
        Assert.assertNotNull(identityType);
        junit.framework.Assert.assertEquals((String)identityType.getId(), (String)lookedUpIdentityType.getId());
        lookedUpIdentityType = identityManager.lookupIdentityById(IdentityType.class, identityType.getId());
        Assert.assertNotNull(identityType);
        junit.framework.Assert.assertEquals((String)identityType.getId(), (String)lookedUpIdentityType.getId());
        junit.framework.Assert.assertNull((Object)identityManager.lookupIdentityById(identityType.getClass(), "bad_id"));
    }

    protected abstract T createIdentityType();

    protected abstract T getIdentityType();

    @Test
    public void testExpiration() throws Exception {
        T validIdentityType = this.createIdentityType();
        Date expirationDate = new Date();
        validIdentityType.setExpirationDate(expirationDate);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update(validIdentityType);
        T expiredIdentityType = this.getIdentityType();
        Assert.assertNotNull((Object)expiredIdentityType.getExpirationDate());
        junit.framework.Assert.assertTrue((expirationDate.compareTo(expiredIdentityType.getExpirationDate()) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSetOneValuedAttribute() throws Exception {
        T storedIdentityType = this.createIdentityType();
        storedIdentityType.setAttribute(new Attribute("one-valued", (Serializable)((Object)"1")));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update(storedIdentityType);
        T updatedIdentityType = this.getIdentityType();
        Attribute oneValuedAttribute = updatedIdentityType.getAttribute("one-valued");
        Assert.assertNotNull((Object)oneValuedAttribute);
        junit.framework.Assert.assertEquals((String)"1", (String)((String)((Object)oneValuedAttribute.getValue())));
    }

    @Test
    public void testSetMultiValuedAttribute() throws Exception {
        T storedIdentityType = this.createIdentityType();
        storedIdentityType.setAttribute(new Attribute("multi-valued", (Serializable)new String[]{"1", "2", "3"}));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update(storedIdentityType);
        T updatedIdentityType = this.getIdentityType();
        Attribute multiValuedAttribute = updatedIdentityType.getAttribute("multi-valued");
        Assert.assertNotNull((Object)multiValuedAttribute);
        Assert.assertNotNull((Object)multiValuedAttribute.getValue());
        junit.framework.Assert.assertEquals((int)3, (int)((String[])multiValuedAttribute.getValue()).length);
        Object[] values = (String[])multiValuedAttribute.getValue();
        Arrays.sort(values);
        junit.framework.Assert.assertTrue((boolean)Arrays.equals(values, new String[]{"1", "2", "3"}));
    }

    @Test
    public void testSetMultipleAttributes() throws Exception {
        T storedIdentityType = this.createIdentityType();
        storedIdentityType.setAttribute(new Attribute("QuestionTotal", (Serializable)((Object)"2")));
        storedIdentityType.setAttribute(new Attribute("Question1", (Serializable)((Object)"What is favorite toy?")));
        storedIdentityType.setAttribute(new Attribute("Question1Answer", (Serializable)((Object)"Gum")));
        storedIdentityType.setAttribute(new Attribute("Question2", (Serializable)((Object)"What is favorite word?")));
        storedIdentityType.setAttribute(new Attribute("Question2Answer", (Serializable)((Object)"Hi")));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update(storedIdentityType);
        T updatedIdentityType = this.getIdentityType();
        junit.framework.Assert.assertEquals((String)"2", (String)((String)((Object)updatedIdentityType.getAttribute("QuestionTotal").getValue())));
        junit.framework.Assert.assertEquals((String)"What is favorite toy?", (String)((String)((Object)updatedIdentityType.getAttribute("Question1").getValue())));
        junit.framework.Assert.assertEquals((String)"Gum", (String)((String)((Object)updatedIdentityType.getAttribute("Question1Answer").getValue())));
        junit.framework.Assert.assertEquals((String)"What is favorite word?", (String)((String)((Object)updatedIdentityType.getAttribute("Question2").getValue())));
        junit.framework.Assert.assertEquals((String)"Hi", (String)((String)((Object)updatedIdentityType.getAttribute("Question2Answer").getValue())));
    }

    @Test
    public void testGetAllAttributes() throws Exception {
        T storedIdentityType = this.createIdentityType();
        storedIdentityType.setAttribute(new Attribute("QuestionTotal", (Serializable)((Object)"2")));
        storedIdentityType.setAttribute(new Attribute("Question1", (Serializable)((Object)"What is favorite toy?")));
        storedIdentityType.setAttribute(new Attribute("Question1Answer", (Serializable)((Object)"Gum")));
        storedIdentityType.setAttribute(new Attribute("Question2", (Serializable)((Object)"What is favorite word?")));
        storedIdentityType.setAttribute(new Attribute("Question2Answer", (Serializable)((Object)"Hi")));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update(storedIdentityType);
        T updatedIdentityType = this.getIdentityType();
        Collection allAttributes = updatedIdentityType.getAttributes();
        junit.framework.Assert.assertFalse((boolean)allAttributes.isEmpty());
        boolean hasQuestionTotal = false;
        boolean hasQuestion1 = false;
        boolean hasQuestion1Answer = false;
        boolean hasQuestion2 = false;
        boolean hasQuestion2Answer = false;
        for (Attribute attribute : allAttributes) {
            if (attribute.getName().equals("QuestionTotal")) {
                hasQuestionTotal = true;
            }
            if (attribute.getName().equals("Question1")) {
                hasQuestion1 = true;
            }
            if (attribute.getName().equals("Question1Answer")) {
                hasQuestion1Answer = true;
            }
            if (attribute.getName().equals("Question2")) {
                hasQuestion2 = true;
            }
            if (!attribute.getName().equals("Question2Answer")) continue;
            hasQuestion2Answer = true;
        }
        junit.framework.Assert.assertTrue((boolean)hasQuestionTotal);
        junit.framework.Assert.assertTrue((boolean)hasQuestion1);
        junit.framework.Assert.assertTrue((boolean)hasQuestion1Answer);
        junit.framework.Assert.assertTrue((boolean)hasQuestion2);
        junit.framework.Assert.assertTrue((boolean)hasQuestion2Answer);
    }

    @Test
    public void testUpdateAttribute() throws Exception {
        T storedIdentityType = this.createIdentityType();
        storedIdentityType.setAttribute(new Attribute("multi-valued", (Serializable)new String[]{"1", "2", "3"}));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update(storedIdentityType);
        T updatedIdentityType = this.getIdentityType();
        Attribute multiValuedAttribute = updatedIdentityType.getAttribute("multi-valued");
        Assert.assertNotNull((Object)multiValuedAttribute);
        multiValuedAttribute.setValue((Serializable)new String[]{"3", "4", "5"});
        updatedIdentityType.setAttribute(multiValuedAttribute);
        identityManager.update(updatedIdentityType);
        updatedIdentityType = this.getIdentityType();
        multiValuedAttribute = updatedIdentityType.getAttribute("multi-valued");
        Assert.assertNotNull((Object)multiValuedAttribute);
        junit.framework.Assert.assertEquals((int)3, (int)((String[])multiValuedAttribute.getValue()).length);
        Object[] values = (String[])multiValuedAttribute.getValue();
        Arrays.sort(values);
        junit.framework.Assert.assertTrue((boolean)Arrays.equals(values, new String[]{"3", "4", "5"}));
    }

    @Test
    public void testRemoveAttribute() throws Exception {
        T storedIdentityType = this.createIdentityType();
        storedIdentityType.setAttribute(new Attribute("multi-valued", (Serializable)new String[]{"1", "2", "3"}));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update(storedIdentityType);
        T updatedIdentityType = this.getIdentityType();
        Attribute multiValuedAttribute = updatedIdentityType.getAttribute("multi-valued");
        Assert.assertNotNull((Object)multiValuedAttribute);
        updatedIdentityType.removeAttribute("multi-valued");
        identityManager.update(updatedIdentityType);
        updatedIdentityType = this.getIdentityType();
        multiValuedAttribute = updatedIdentityType.getAttribute("multi-valued");
        junit.framework.Assert.assertNull((Object)multiValuedAttribute);
    }
}

