/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.basic;

import java.io.Serializable;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.test.idm.AbstractIdentityTypeTestCase;

public class AgentManagementTestCase
extends AbstractIdentityTypeTestCase<Agent> {
    @Test
    public void testCreate() throws Exception {
        Agent newAgent = this.createIdentityType();
        IdentityManager identityManager = this.getIdentityManager();
        Agent storedAgent = identityManager.getAgent(newAgent.getLoginName());
        Assert.assertNotNull((Object)storedAgent);
        junit.framework.Assert.assertEquals((String)newAgent.getId(), (String)storedAgent.getId());
        junit.framework.Assert.assertEquals((String)newAgent.getLoginName(), (String)storedAgent.getLoginName());
        junit.framework.Assert.assertTrue((boolean)storedAgent.isEnabled());
        Assert.assertNotNull((Object)storedAgent.getPartition());
        junit.framework.Assert.assertEquals((String)"default", (String)storedAgent.getPartition().getName());
        junit.framework.Assert.assertTrue((boolean)storedAgent.isEnabled());
        junit.framework.Assert.assertNull((Object)storedAgent.getExpirationDate());
        Assert.assertNotNull((Object)storedAgent.getCreatedDate());
        junit.framework.Assert.assertTrue((new Date().compareTo(storedAgent.getCreatedDate()) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUpdate() throws Exception {
        Agent storedAgent = this.createIdentityType();
        IdentityManager identityManager = this.getIdentityManager();
        Date actualDate = new Date();
        storedAgent.setExpirationDate(actualDate);
        storedAgent.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"1")));
        identityManager.update((IdentityType)storedAgent);
        Agent updatedUser = identityManager.getAgent(storedAgent.getLoginName());
        Assert.assertNotNull((Object)updatedUser.getAttribute("someAttribute"));
        junit.framework.Assert.assertEquals((Object)"1", (Object)updatedUser.getAttribute("someAttribute").getValue());
        junit.framework.Assert.assertEquals((Object)actualDate, (Object)updatedUser.getExpirationDate());
    }

    @Test
    public void testRemove() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Agent someAgent = this.createIdentityType();
        Agent anotherAgent = this.createAgent("someAnotherAgent");
        identityManager.remove((IdentityType)someAgent);
        Agent removedUserInstance = this.getIdentityManager().getAgent(someAgent.getLoginName());
        junit.framework.Assert.assertNull((Object)removedUserInstance);
        anotherAgent = identityManager.getAgent(anotherAgent.getLoginName());
        Assert.assertNotNull((Object)anotherAgent);
    }

    @Override
    protected Agent getIdentityType() {
        return this.getIdentityManager().getAgent("someAgent");
    }

    @Override
    protected Agent createIdentityType() {
        return this.createAgent("someAgent");
    }
}

