/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.basic;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.test.idm.AbstractIdentityTypeTestCase;

public class GroupManagementTestCase
extends AbstractIdentityTypeTestCase<Group> {
    @Test
    public void testCreate() throws Exception {
        Group newGroup = this.createGroup("someGroup", null);
        Assert.assertNotNull((Object)newGroup.getId());
        IdentityManager identityManager = this.getIdentityManager();
        Group storedGroup = identityManager.getGroup(newGroup.getName());
        Assert.assertNotNull((Object)storedGroup);
        junit.framework.Assert.assertEquals((String)newGroup.getId(), (String)storedGroup.getId());
        junit.framework.Assert.assertEquals((String)newGroup.getName(), (String)storedGroup.getName());
        Assert.assertNotNull((Object)storedGroup.getPartition());
        junit.framework.Assert.assertEquals((String)"default", (String)storedGroup.getPartition().getName());
        junit.framework.Assert.assertTrue((boolean)storedGroup.isEnabled());
        junit.framework.Assert.assertNull((Object)storedGroup.getExpirationDate());
        Assert.assertNotNull((Object)storedGroup.getCreatedDate());
        junit.framework.Assert.assertTrue((new Date().compareTo(storedGroup.getCreatedDate()) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateWithParentGroup() throws Exception {
        Group childGroup = this.createGroup("childGroup", "parentGroup");
        IdentityManager identityManager = this.getIdentityManager();
        Group storedChildGroup = identityManager.getGroup(childGroup.getName());
        Assert.assertNotNull((Object)storedChildGroup);
        junit.framework.Assert.assertEquals((String)childGroup.getName(), (String)storedChildGroup.getName());
        Assert.assertNotNull((Object)storedChildGroup.getParentGroup());
        junit.framework.Assert.assertEquals((String)childGroup.getParentGroup().getId(), (String)storedChildGroup.getParentGroup().getId());
    }

    @Test
    public void testGetWithParent() throws Exception {
        Group storedGroup = this.createIdentityType();
        IdentityManager identityManager = this.getIdentityManager();
        storedGroup = identityManager.getGroup("Test Group", (Group)new SimpleGroup("Test Parent Group"));
        Assert.assertNotNull((Object)storedGroup);
        Assert.assertNotNull((Object)storedGroup.getParentGroup());
        junit.framework.Assert.assertEquals((String)"Test Group", (String)storedGroup.getName());
        Group invalidGroup = identityManager.getGroup("Test Group", (Group)new SimpleGroup("Invalid Parent Group"));
        junit.framework.Assert.assertNull((Object)invalidGroup);
    }

    @Test
    public void testRemove() throws Exception {
        Group storedGroup = this.createIdentityType();
        Assert.assertNotNull((Object)storedGroup);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.remove((IdentityType)storedGroup);
        Group removedGroup = identityManager.getGroup(storedGroup.getName());
        junit.framework.Assert.assertNull((Object)removedGroup);
    }

    @Override
    protected Group createIdentityType() {
        return this.createGroup("Test Group", "Test Parent Group");
    }

    @Override
    protected Group getIdentityType() {
        return this.getGroup("Test Group");
    }
}

