/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.basic;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.test.idm.AbstractIdentityTypeTestCase;

public class RoleManagementTestCase
extends AbstractIdentityTypeTestCase<Role> {
    @Test
    public void testCreate() throws Exception {
        Role newRole = this.createRole("someRole");
        Assert.assertNotNull((Object)newRole.getId());
        IdentityManager identityManager = this.getIdentityManager();
        Role storedRole = identityManager.getRole(newRole.getName());
        Assert.assertNotNull((Object)storedRole);
        junit.framework.Assert.assertEquals((String)newRole.getId(), (String)storedRole.getId());
        junit.framework.Assert.assertEquals((String)newRole.getName(), (String)storedRole.getName());
        Assert.assertNotNull((Object)storedRole.getPartition());
        junit.framework.Assert.assertEquals((String)"default", (String)storedRole.getPartition().getName());
        Assert.assertNotNull((Object)storedRole.getPartition());
        junit.framework.Assert.assertEquals((String)"default", (String)storedRole.getPartition().getName());
        junit.framework.Assert.assertTrue((boolean)storedRole.isEnabled());
        junit.framework.Assert.assertNull((Object)storedRole.getExpirationDate());
        Assert.assertNotNull((Object)storedRole.getCreatedDate());
        junit.framework.Assert.assertTrue((new Date().compareTo(storedRole.getCreatedDate()) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() throws Exception {
        Role storedRole = this.createIdentityType();
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.remove((IdentityType)storedRole);
        Role removedRole = identityManager.getRole(storedRole.getName());
        junit.framework.Assert.assertNull((Object)removedRole);
    }

    @Override
    protected Role createIdentityType() {
        return this.createRole("Administrator");
    }

    @Override
    protected Role getIdentityType() {
        return this.getIdentityManager().getRole("Administrator");
    }
}

