/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.basic;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.User;
import org.picketlink.test.idm.AbstractIdentityTypeTestCase;

public class UserManagementTestCase
extends AbstractIdentityTypeTestCase<User> {
    @Test
    public void testCreate() throws Exception {
        User newUser = this.createUser("jduke");
        Assert.assertNotNull((Object)newUser.getId());
        newUser.setEmail("jduke@jboss.org");
        newUser.setFirstName("Java");
        newUser.setLastName("Duke");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)newUser);
        User storedUser = identityManager.getUser(newUser.getLoginName());
        Assert.assertNotNull((Object)storedUser);
        junit.framework.Assert.assertEquals((String)newUser.getId(), (String)storedUser.getId());
        junit.framework.Assert.assertEquals((String)newUser.getLoginName(), (String)storedUser.getLoginName());
        junit.framework.Assert.assertEquals((String)newUser.getFirstName(), (String)storedUser.getFirstName());
        junit.framework.Assert.assertEquals((String)newUser.getLastName(), (String)storedUser.getLastName());
        junit.framework.Assert.assertEquals((String)newUser.getEmail(), (String)storedUser.getEmail());
        Assert.assertNotNull((Object)storedUser.getPartition());
        junit.framework.Assert.assertEquals((String)"default", (String)storedUser.getPartition().getName());
        junit.framework.Assert.assertTrue((boolean)storedUser.isEnabled());
        junit.framework.Assert.assertNull((Object)storedUser.getExpirationDate());
        Assert.assertNotNull((Object)storedUser.getCreatedDate());
        junit.framework.Assert.assertTrue((new Date().compareTo(storedUser.getCreatedDate()) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUpdate() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User storedUser = this.createUser("admin");
        storedUser.setEmail("admin@jboss.org");
        storedUser.setFirstName("The");
        storedUser.setLastName("Administrator");
        identityManager.update((IdentityType)storedUser);
        storedUser = identityManager.getUser(storedUser.getLoginName());
        junit.framework.Assert.assertEquals((String)"admin", (String)storedUser.getLoginName());
        junit.framework.Assert.assertEquals((String)"The", (String)storedUser.getFirstName());
        junit.framework.Assert.assertEquals((String)"Administrator", (String)storedUser.getLastName());
        junit.framework.Assert.assertEquals((String)"admin@jboss.org", (String)storedUser.getEmail());
        storedUser.setFirstName("Updated " + storedUser.getFirstName());
        storedUser.setLastName("Updated " + storedUser.getLastName());
        storedUser.setEmail("Updated " + storedUser.getEmail());
        Date actualDate = new Date();
        storedUser.setExpirationDate(actualDate);
        identityManager.update((IdentityType)storedUser);
        User updatedUser = identityManager.getUser(storedUser.getLoginName());
        junit.framework.Assert.assertEquals((String)"Updated The", (String)updatedUser.getFirstName());
        junit.framework.Assert.assertEquals((String)"Updated Administrator", (String)updatedUser.getLastName());
        junit.framework.Assert.assertEquals((String)"Updated admin@jboss.org", (String)updatedUser.getEmail());
        junit.framework.Assert.assertEquals((Object)actualDate, (Object)updatedUser.getExpirationDate());
    }

    @Test
    public void testRemove() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User someUser = this.createUser("admin");
        User anotherUser = this.createUser("someAnotherUser");
        identityManager.remove((IdentityType)someUser);
        User removedUser = this.getIdentityManager().getUser(someUser.getLoginName());
        junit.framework.Assert.assertNull((Object)removedUser);
        anotherUser = identityManager.getUser(anotherUser.getLoginName());
        Assert.assertNotNull((Object)anotherUser);
    }

    @Override
    protected User createIdentityType() {
        return this.createUser("admin");
    }

    @Override
    protected User getIdentityType() {
        return this.getIdentityManager().getUser("admin");
    }
}

