/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.partition;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class RealmManagementTestCase
extends AbstractIdentityManagerTestCase {
    private static final String TESTING_REALM_NAME = "Testing";

    @Test
    public void testCreate() throws Exception {
        Realm realm = this.createRealm();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        realm = defaultIdentityManager.getRealm(realm.getName());
        Assert.assertNotNull((Object)realm);
        Assert.assertEquals((Object)TESTING_REALM_NAME, (Object)realm.getName());
        Assert.assertEquals((Object)"REALM://Testing", (Object)realm.getKey());
    }

    @Test
    public void testGetDefaultRealm() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        Realm defaultRealm = defaultIdentityManager.getRealm("default");
        Assert.assertNotNull((Object)defaultRealm);
        Assert.assertEquals((Object)"default", (Object)defaultRealm.getName());
    }

    @Test(expected=IdentityManagementException.class)
    public void testCreateWithNullArgument() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        defaultIdentityManager.createRealm(null);
    }

    @Test(expected=InstantiationError.class)
    public void testCreateWithNullName() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        defaultIdentityManager.createRealm(new Realm(null));
    }

    @Test
    public void testRemove() throws Exception {
        Realm realm = this.createRealm();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        defaultIdentityManager.removeRealm(realm);
        realm = defaultIdentityManager.getRealm(realm.getName());
        Assert.assertNull((Object)realm);
    }

    @Test(expected=IdentityManagementException.class)
    public void testRemoveWithUsers() throws Exception {
        Realm realm = this.createRealm();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        IdentityManager testingIdentityManager = defaultIdentityManager.forRealm(realm);
        SimpleUser testingUser = new SimpleUser("testingUser");
        testingIdentityManager.add((IdentityType)testingUser);
        defaultIdentityManager.removeRealm(realm);
    }

    @Test(expected=IdentityManagementException.class)
    public void testRemoveWithRoles() throws Exception {
        Realm realm = this.createRealm();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        IdentityManager testingIdentityManager = defaultIdentityManager.forRealm(realm);
        SimpleRole testingRole = new SimpleRole("testingRole");
        testingIdentityManager.add((IdentityType)testingRole);
        defaultIdentityManager.removeRealm(realm);
    }

    @Test(expected=IdentityManagementException.class)
    public void testRemoveWithGroups() throws Exception {
        Realm realm = this.createRealm();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        IdentityManager testingIdentityManager = defaultIdentityManager.forRealm(realm);
        SimpleGroup testingGroup = new SimpleGroup("testingGroup");
        testingIdentityManager.add((IdentityType)testingGroup);
        defaultIdentityManager.removeRealm(realm);
    }

    @Test
    public void testCreateUsers() throws Exception {
        Realm realm = this.createRealm();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        SimpleUser realmUser = new SimpleUser("realmUser");
        defaultIdentityManager.forRealm(realm).add((IdentityType)realmUser);
        realmUser = defaultIdentityManager.forRealm(realm).getUser(realmUser.getLoginName());
        Assert.assertNotNull((Object)realmUser);
        Assert.assertNotNull((Object)realmUser.getPartition());
        Assert.assertEquals((Object)realm.getId(), (Object)realmUser.getPartition().getId());
        realmUser = defaultIdentityManager.getUser(realmUser.getLoginName());
        Assert.assertNull((Object)realmUser);
    }

    @Test
    public void testCreateRoles() throws Exception {
        Realm realm = this.createRealm();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        SimpleRole testingRole = new SimpleRole("testingRole");
        defaultIdentityManager.forRealm(realm).add((IdentityType)testingRole);
        testingRole = defaultIdentityManager.forRealm(realm).getRole(testingRole.getName());
        Assert.assertNotNull((Object)testingRole);
        Assert.assertNotNull((Object)testingRole.getPartition());
        Assert.assertEquals((Object)realm.getId(), (Object)testingRole.getPartition().getId());
        testingRole = defaultIdentityManager.getRole(testingRole.getName());
        Assert.assertNull((Object)testingRole);
    }

    @Test
    public void testCreateGroups() throws Exception {
        Realm realm = this.createRealm();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        SimpleGroup testingGroup = new SimpleGroup("testingRealmGroup");
        defaultIdentityManager.forRealm(realm).add((IdentityType)testingGroup);
        testingGroup = defaultIdentityManager.forRealm(realm).getGroup(testingGroup.getName());
        Assert.assertNotNull((Object)testingGroup);
        Assert.assertNotNull((Object)testingGroup.getPartition());
        Assert.assertEquals((Object)realm.getId(), (Object)testingGroup.getPartition().getId());
        testingGroup = defaultIdentityManager.getGroup(testingGroup.getName());
        Assert.assertNull((Object)testingGroup);
    }

    private Realm createRealm() {
        IdentityManager identityManager = this.getIdentityManager();
        Realm realm = identityManager.getRealm(TESTING_REALM_NAME);
        if (realm == null) {
            realm = new Realm(TESTING_REALM_NAME);
            identityManager.createRealm(realm);
        }
        return realm;
    }
}

