/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.partition;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.Tier;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class TierManagementTestCase
extends AbstractIdentityManagerTestCase {
    private static final String SERVICES_TIER_NAME = "Services";
    private static final String APPLICATION_TIER_NAME = "Application";
    private static final String TESTING_TIER_NAME = "Testing Tier";

    @Test
    public void testCreate() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Tier testingTier = this.createTestingTier();
        testingTier = identityManager.getTier(testingTier.getName());
        Assert.assertNotNull((Object)testingTier);
        Assert.assertEquals((Object)TESTING_TIER_NAME, (Object)testingTier.getName());
        Assert.assertEquals((Object)"TIER://Testing Tier", (Object)testingTier.getKey());
    }

    @Test
    public void testCreateWithParent() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Tier applicationTier = this.createApplicationTier();
        applicationTier = identityManager.getTier(applicationTier.getName());
        Tier serviceTier = this.createServicesTier(applicationTier);
        serviceTier = identityManager.getTier(serviceTier.getName());
        Assert.assertNotNull((Object)serviceTier);
        Assert.assertEquals((Object)SERVICES_TIER_NAME, (Object)serviceTier.getName());
        Assert.assertNotNull((Object)serviceTier.getParent());
        Assert.assertEquals((Object)applicationTier.getName(), (Object)serviceTier.getParent().getName());
    }

    @Test
    public void testRemoveTier() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Tier testingTier = this.createTestingTier();
        Assert.assertNotNull((Object)testingTier);
        identityManager.removeTier(testingTier);
        testingTier = identityManager.getTier(testingTier.getName());
        Assert.assertNull((Object)testingTier);
    }

    @Test(expected=IdentityManagementException.class)
    public void testRemoveWithRoles() throws Exception {
        Tier applicationTier = this.createApplicationTier();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        IdentityManager applicationTierIdentityManager = defaultIdentityManager.forTier(applicationTier);
        SimpleRole testingRole = new SimpleRole("testingRole");
        applicationTierIdentityManager.add((IdentityType)testingRole);
        defaultIdentityManager.removeTier(applicationTier);
    }

    @Test(expected=IdentityManagementException.class)
    public void testRemoveTierGroups() throws Exception {
        Tier applicationTier = this.createApplicationTier();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        IdentityManager applicationTierIdentityManager = defaultIdentityManager.forTier(applicationTier);
        SimpleGroup testingGroup = new SimpleGroup("testingGroup");
        applicationTierIdentityManager.add((IdentityType)testingGroup);
        defaultIdentityManager.removeTier(applicationTier);
    }

    @Test
    public void testRolesForTierWithParent() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        Tier parentTier = this.createApplicationTier();
        SimpleRole testingRole = new SimpleRole("testingRole");
        defaultIdentityManager.forTier(parentTier).add((IdentityType)testingRole);
        testingRole = defaultIdentityManager.forTier(parentTier).getRole("testingRole");
        Assert.assertNotNull((Object)testingRole);
        Tier servicesTier = this.createServicesTier(null);
        testingRole = defaultIdentityManager.forTier(servicesTier).getRole("testingRole");
        Assert.assertNull((Object)testingRole);
        servicesTier = this.createServicesTier(parentTier);
        testingRole = defaultIdentityManager.forTier(servicesTier).getRole("testingRole");
        Assert.assertNotNull((Object)testingRole);
    }

    @Test
    public void testCreateRoles() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        Tier applicationTier = this.createApplicationTier();
        IdentityManager applicationTierIdentityManager = defaultIdentityManager.forTier(applicationTier);
        SimpleRole testingRole = new SimpleRole("testingRole");
        applicationTierIdentityManager.add((IdentityType)testingRole);
        testingRole = applicationTierIdentityManager.getRole(testingRole.getName());
        Assert.assertNotNull((Object)testingRole);
        Assert.assertNotNull((Object)testingRole.getPartition());
        Assert.assertEquals((Object)applicationTier.getId(), (Object)testingRole.getPartition().getId());
        testingRole = defaultIdentityManager.getRole(testingRole.getName());
        Assert.assertNull((Object)testingRole);
    }

    @Test
    public void testGrantUserRoles() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        Tier applicationTier = this.createApplicationTier();
        IdentityManager applicationTierIdentityManager = defaultIdentityManager.forTier(applicationTier);
        SimpleRole adminRole = new SimpleRole("Administrator");
        applicationTierIdentityManager.add((IdentityType)adminRole);
        adminRole = applicationTierIdentityManager.getRole(adminRole.getName());
        Assert.assertNotNull((Object)adminRole);
        Realm testingRealm = this.createRealm();
        IdentityManager testingRealmIdentityManager = applicationTierIdentityManager.forRealm(testingRealm);
        SimpleUser someUser = new SimpleUser("someUser");
        testingRealmIdentityManager.add((IdentityType)someUser);
        testingRealmIdentityManager.grantRole((IdentityType)someUser, (Role)adminRole);
        Assert.assertTrue((boolean)testingRealmIdentityManager.hasRole((IdentityType)someUser, (Role)adminRole));
        Assert.assertTrue((boolean)applicationTierIdentityManager.hasRole((IdentityType)someUser, (Role)adminRole));
    }

    @Test
    public void testGroupsForTier() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Tier applicationTier = this.createApplicationTier();
        IdentityManager applicationTierIdentityManager = identityManager.forTier(applicationTier);
        SimpleGroup testingGroup = new SimpleGroup("testingGroupTier");
        applicationTierIdentityManager.add((IdentityType)testingGroup);
        testingGroup = applicationTierIdentityManager.getGroup(testingGroup.getName());
        Assert.assertNotNull((Object)testingGroup);
        Assert.assertNotNull((Object)testingGroup.getPartition());
        Assert.assertEquals((Object)applicationTier.getId(), (Object)testingGroup.getPartition().getId());
        testingGroup = identityManager.getGroup(testingGroup.getName());
        Assert.assertNull((Object)testingGroup);
    }

    @Test
    public void testGroupsForTierWithParent() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        Tier parentTier = this.createApplicationTier();
        SimpleGroup testingGroup = new SimpleGroup("testingGroupParentTier");
        defaultIdentityManager.forTier(parentTier).add((IdentityType)testingGroup);
        testingGroup = defaultIdentityManager.forTier(parentTier).getGroup("testingGroupParentTier");
        Assert.assertNotNull((Object)testingGroup);
        Tier servicesTier = this.createServicesTier(null);
        testingGroup = defaultIdentityManager.forTier(servicesTier).getGroup("testingGroupParentTier");
        Assert.assertNull((Object)testingGroup);
        servicesTier = this.createServicesTier(parentTier);
        testingGroup = defaultIdentityManager.forTier(servicesTier).getGroup("testingGroupParentTier");
        Assert.assertNotNull((Object)testingGroup);
    }

    private Tier createApplicationTier() {
        IdentityManager identityManager = this.getIdentityManager();
        Tier tier = identityManager.getTier(APPLICATION_TIER_NAME);
        if (tier == null) {
            tier = new Tier(APPLICATION_TIER_NAME);
            identityManager.createTier(tier);
        }
        return tier;
    }

    private Tier createTestingTier() {
        IdentityManager identityManager = this.getIdentityManager();
        Tier tier = identityManager.getTier(TESTING_TIER_NAME);
        if (tier == null) {
            tier = new Tier(TESTING_TIER_NAME);
            identityManager.createTier(tier);
        }
        return tier;
    }

    private Tier createServicesTier(Tier parentTier) {
        IdentityManager identityManager = this.getIdentityManager();
        Tier serviceTier = identityManager.getTier(SERVICES_TIER_NAME);
        if (serviceTier != null) {
            identityManager.removeTier(serviceTier);
        }
        serviceTier = parentTier != null ? new Tier(SERVICES_TIER_NAME, parentTier) : new Tier(SERVICES_TIER_NAME);
        identityManager.createTier(serviceTier);
        return serviceTier;
    }

    private Realm createRealm() {
        IdentityManager identityManager = this.getIdentityManager();
        Realm realm = identityManager.getRealm("Testing");
        if (realm == null) {
            realm = new Realm("Testing");
            identityManager.createRealm(realm);
        }
        return realm;
    }
}

