/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleAgent;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class AgentQueryTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testFindById() throws Exception {
        Agent agent = this.createAgent("someAgent");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.ID, new Object[]{agent.getId()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)agent.getLoginName(), (String)((Agent)result.get(0)).getLoginName());
    }

    @Test
    public void testPagination() throws Exception {
        for (int i = 0; i < 50; ++i) {
            this.createAgent("someAgent" + i + 1);
        }
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        query.setLimit(10);
        query.setOffset(0);
        int resultCount = query.getResultCount();
        junit.framework.Assert.assertEquals((int)50, (int)resultCount);
        List firstPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)firstPage.size());
        ArrayList<String> agentIds = new ArrayList<String>();
        for (Agent Agent2 : firstPage) {
            agentIds.add(Agent2.getId());
        }
        query.setOffset(10);
        List secondPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)secondPage.size());
        for (Agent Agent3 : secondPage) {
            junit.framework.Assert.assertFalse((boolean)agentIds.contains(Agent3.getId()));
            agentIds.add(Agent3.getId());
        }
        query.setOffset(20);
        List thirdPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)thirdPage.size());
        for (Agent Agent4 : thirdPage) {
            junit.framework.Assert.assertFalse((boolean)agentIds.contains(Agent4.getId()));
            agentIds.add(Agent4.getId());
        }
        query.setOffset(30);
        List fourthPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)fourthPage.size());
        for (Agent Agent5 : fourthPage) {
            junit.framework.Assert.assertFalse((boolean)agentIds.contains(Agent5.getId()));
            agentIds.add(Agent5.getId());
        }
        query.setOffset(40);
        List fifthyPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)fifthyPage.size());
        for (Agent Agent6 : fifthyPage) {
            junit.framework.Assert.assertFalse((boolean)agentIds.contains(Agent6.getId()));
            agentIds.add(Agent6.getId());
        }
        junit.framework.Assert.assertEquals((int)50, (int)agentIds.size());
        query.setOffset(50);
        List invalidPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)0, (int)invalidPage.size());
    }

    @Test
    public void testFindByRealm() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        SimpleAgent someAgentDefaultRealm = new SimpleAgent("someAgentRealm");
        identityManager.add((IdentityType)someAgentDefaultRealm);
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        Realm defaultRealm = identityManager.getRealm("default");
        Assert.assertNotNull((Object)defaultRealm);
        query.setParameter(Agent.PARTITION, new Object[]{defaultRealm});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)someAgentDefaultRealm.getLoginName(), (String)((Agent)result.get(0)).getLoginName());
        Realm testingRealm = identityManager.getRealm("Testing");
        if (testingRealm == null) {
            testingRealm = new Realm("Testing");
            identityManager.createRealm(testingRealm);
        }
        SimpleAgent someAgentTestingRealm = new SimpleAgent("someAgentTestingRealm");
        identityManager.forRealm(testingRealm).add((IdentityType)someAgentTestingRealm);
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.PARTITION, new Object[]{testingRealm});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)someAgentTestingRealm.getLoginName(), (String)((Agent)result.get(0)).getLoginName());
    }

    @Test
    public void testFindByLoginName() throws Exception {
        Agent user = this.createAgent("someAgent");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.LOGIN_NAME, new Object[]{"someAgent"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((Agent)result.get(0)).getLoginName());
    }

    @Test
    public void testFindBySingleGroupRole() throws Exception {
        Agent user = this.createAgent("someAgent");
        Group salesGroup = this.createGroup("Sales", null);
        Role managerRole = this.createRole("Manager");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.HAS_GROUP_ROLE, new Object[]{new GroupRole((IdentityType)user, salesGroup, managerRole)});
        List result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        identityManager.grantGroupRole((IdentityType)user, managerRole, salesGroup);
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.HAS_GROUP_ROLE, new Object[]{new GroupRole((IdentityType)user, salesGroup, managerRole)});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((Agent)result.get(0)).getLoginName());
    }

    @Test
    public void testFindBySingleGroup() throws Exception {
        Agent user = this.createAgent("admin");
        Group administratorGroup = this.createGroup("Administrators", null);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.MEMBER_OF, new Object[]{"Administrators"});
        List result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        identityManager.addToGroup((IdentityType)user, administratorGroup);
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.MEMBER_OF, new Object[]{"Administrators"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((Agent)result.get(0)).getLoginName());
    }

    @Test
    public void testFindBySingleRole() throws Exception {
        Agent user = this.createAgent("admin");
        Role administratorRole = this.createRole("Administrators");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.HAS_ROLE, new Object[]{"Administrators"});
        List result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        identityManager.grantRole((IdentityType)user, administratorRole);
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.HAS_ROLE, new Object[]{"Administrators"});
        result = query.getResultList();
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((Agent)result.get(0)).getLoginName());
    }

    @Test
    public void testFindByMultipleGroups() throws Exception {
        Agent user = this.createAgent("admin");
        Group administratorGroup = this.createGroup("Administrators", null);
        Group someGroup = this.createGroup("someGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((IdentityType)user, administratorGroup);
        identityManager.addToGroup((IdentityType)user, someGroup);
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.MEMBER_OF, new Object[]{administratorGroup.getName(), someGroup.getName()});
        List result = query.getResultList();
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((Agent)result.get(0)).getLoginName());
        identityManager.removeFromGroup((IdentityType)user, someGroup);
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.MEMBER_OF, new Object[]{administratorGroup.getName(), someGroup.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.MEMBER_OF, new Object[]{administratorGroup.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((Agent)result.get(0)).getLoginName());
    }

    @Test
    public void testFindByMultipleRoles() throws Exception {
        Agent user = this.createAgent("admin");
        Role administratorRole = this.createRole("Administrators");
        Role someRole = this.createRole("someRole");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole((IdentityType)user, administratorRole);
        identityManager.grantRole((IdentityType)user, someRole);
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.HAS_ROLE, new Object[]{administratorRole.getName(), someRole.getName()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((Agent)result.get(0)).getLoginName());
        identityManager.revokeRole((IdentityType)user, someRole);
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.HAS_ROLE, new Object[]{administratorRole.getName(), someRole.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.HAS_ROLE, new Object[]{administratorRole.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((Agent)result.get(0)).getLoginName());
    }

    @Test
    public void testFindByMultipleAgentWithGroups() throws Exception {
        Agent adminAgent = this.createAgent("admin");
        Agent someAgent = this.createAgent("someAgent");
        Group administratorGroup = this.createGroup("Administrators", null);
        Group someGroup = this.createGroup("someGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((IdentityType)adminAgent, administratorGroup);
        identityManager.addToGroup((IdentityType)someAgent, administratorGroup);
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.MEMBER_OF, new Object[]{administratorGroup.getName()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)2, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, adminAgent.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAgent.getLoginName()));
        identityManager.addToGroup((IdentityType)adminAgent, someGroup);
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.MEMBER_OF, new Object[]{administratorGroup.getName(), someGroup.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, adminAgent.getLoginName()));
    }

    @Test
    public void testFindByMultipleAgentWithRoles() throws Exception {
        Agent adminAgent = this.createAgent("admin");
        Agent someAgent = this.createAgent("someAgent");
        Role administratorRole = this.createRole("Administrators");
        Role someRole = this.createRole("someRole");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole((IdentityType)adminAgent, administratorRole);
        identityManager.grantRole((IdentityType)someAgent, administratorRole);
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.HAS_ROLE, new Object[]{administratorRole.getName()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)2, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, adminAgent.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAgent.getLoginName()));
        identityManager.grantRole((IdentityType)adminAgent, someRole);
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.HAS_ROLE, new Object[]{administratorRole.getName(), someRole.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, adminAgent.getLoginName()));
    }

    @Test
    public void testFindEnabledAndDisabledAgents() throws Exception {
        Agent someAgent = this.createAgent("someAgent");
        Agent someAnotherAgent = this.createAgent("someAnotherAgent");
        someAgent.setEnabled(true);
        someAnotherAgent.setEnabled(true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someAgent);
        identityManager.update((IdentityType)someAnotherAgent);
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.ENABLED, new Object[]{true});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)2, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAgent.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherAgent.getLoginName()));
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.ENABLED, new Object[]{false});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        someAgent.setEnabled(false);
        identityManager.update((IdentityType)someAgent);
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.ENABLED, new Object[]{false});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAgent.getLoginName()));
        someAnotherAgent.setEnabled(false);
        identityManager.update((IdentityType)someAnotherAgent);
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.ENABLED, new Object[]{true});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindCreationDate() throws Exception {
        Agent user = this.createAgent("someAgent");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.CREATED_DATE, new Object[]{user.getCreatedDate()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((Agent)result.get(0)).getLoginName());
        query = identityManager.createIdentityQuery(Agent.class);
        Calendar futureDate = Calendar.getInstance();
        futureDate.add(12, 1);
        query.setParameter(Agent.CREATED_DATE, new Object[]{futureDate.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindExpiryDate() throws Exception {
        Agent user = this.createAgent("someAgent");
        Date expirationDate = new Date();
        IdentityManager identityManager = this.getIdentityManager();
        user = identityManager.getAgent("someAgent");
        user.setExpirationDate(expirationDate);
        identityManager.update((IdentityType)user);
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.EXPIRY_DATE, new Object[]{user.getExpirationDate()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((Agent)result.get(0)).getLoginName());
        query = identityManager.createIdentityQuery(Agent.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, 1);
        query.setParameter(Agent.EXPIRY_DATE, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBetweenCreationDate() throws Exception {
        Agent someAgent = this.createAgent("someAgent");
        Agent someAnotherAgent = this.createAgent("someAnotherAgent");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        query.setParameter(Agent.CREATED_AFTER, new Object[]{calendar.getTime()});
        query.setParameter(Agent.CREATED_BEFORE, new Object[]{new Date()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)2, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAgent.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherAgent.getLoginName()));
        query = identityManager.createIdentityQuery(Agent.class);
        Agent someFutureAgent = this.createAgent("someFutureAgent");
        Agent someAnotherFutureAgent = this.createAgent("someAnotherFutureAgent");
        query.setParameter(Agent.CREATED_AFTER, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)4, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAgent.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherAgent.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureAgent.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureAgent.getLoginName()));
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.CREATED_BEFORE, new Object[]{new Date()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)4, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAgent.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherAgent.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureAgent.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureAgent.getLoginName()));
        query = identityManager.createIdentityQuery(Agent.class);
        calendar = Calendar.getInstance();
        calendar.add(12, 1);
        query.setParameter(Agent.CREATED_AFTER, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindUsingMultipleParameters() throws Exception {
        Agent user = this.createAgent("admin");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)user);
        user.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        identityManager.update((IdentityType)user);
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, user.getLoginName()));
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.LOGIN_NAME, new Object[]{"admin"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        query.setParameter(Agent.LOGIN_NAME, new Object[]{"admin"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, user.getLoginName()));
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        query.setParameter(Agent.LOGIN_NAME, new Object[]{"Bad ID"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBetweenExpirationDate() throws Exception {
        Agent someAgent = this.createAgent("someAgent");
        Date currentDate = new Date();
        someAgent.setExpirationDate(currentDate);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someAgent);
        Agent someAnotherAgent = this.createAgent("someAnotherAgent");
        someAnotherAgent.setExpirationDate(currentDate);
        identityManager.update((IdentityType)someAnotherAgent);
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        Date expiryDate = calendar.getTime();
        query.setParameter(Agent.EXPIRY_AFTER, new Object[]{expiryDate});
        query.setParameter(Agent.EXPIRY_BEFORE, new Object[]{currentDate});
        Agent someFutureAgent = this.createAgent("someFutureAgent");
        calendar = Calendar.getInstance();
        calendar.add(12, 1);
        someFutureAgent.setExpirationDate(calendar.getTime());
        identityManager.update((IdentityType)someFutureAgent);
        Agent someAnotherFutureAgent = this.createAgent("someAnotherFutureAgent");
        someAnotherFutureAgent.setExpirationDate(calendar.getTime());
        identityManager.update((IdentityType)someAnotherFutureAgent);
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)2, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAgent.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherAgent.getLoginName()));
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter(Agent.EXPIRY_AFTER, new Object[]{expiryDate});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)4, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAgent.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherAgent.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureAgent.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureAgent.getLoginName()));
        query = identityManager.createIdentityQuery(Agent.class);
        calendar = Calendar.getInstance();
        calendar.add(12, 1);
        query.setParameter(Agent.EXPIRY_BEFORE, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)4, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAgent.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherAgent.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureAgent.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureAgent.getLoginName()));
        query = identityManager.createIdentityQuery(Agent.class);
        calendar = Calendar.getInstance();
        calendar.add(12, 2);
        query.setParameter(Agent.EXPIRY_AFTER, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindByAgentDefinedAttributes() throws Exception {
        Agent someAgent = this.createAgent("someAgent");
        someAgent.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someAgent);
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAgent.getLoginName()));
        someAgent.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValueChanged")));
        identityManager.update((IdentityType)someAgent);
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        someAgent.setAttribute(new Attribute("someAttribute2", (Serializable)((Object)"someAttributeValue2")));
        identityManager.update((IdentityType)someAgent);
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAgent.getLoginName()));
    }

    @Test
    public void testFindByAgentDefinedMultiValuedAttributes() throws Exception {
        Agent someAgent = this.createAgent("someAgent");
        someAgent.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValue2"}));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someAgent);
        IdentityQuery query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAgent.getLoginName()));
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged", "someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        someAgent.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValueChanged"}));
        someAgent.setAttribute(new Attribute("someAttribute2", (Serializable)new String[]{"someAttribute2Value1", "someAttribute2Value2"}));
        identityManager.update((IdentityType)someAgent);
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2Value1", "someAttribute2Value2"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAgent.getLoginName()));
        query = identityManager.createIdentityQuery(Agent.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2ValueChanged", "someAttribute2Value2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    private boolean contains(List<Agent> result, String userId) {
        for (Agent resultAgent : result) {
            if (!resultAgent.getLoginName().equals(userId)) continue;
            return true;
        }
        return false;
    }
}

