/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class GroupQueryTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testFindById() throws Exception {
        Group group = this.createGroup("someGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.ID, new Object[]{group.getId()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)group.getName(), (String)((Group)result.get(0)).getName());
    }

    @Test
    public void testPagination() throws Exception {
        for (int i = 0; i < 50; ++i) {
            this.createGroup("someGroup" + i + 1, null);
        }
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setLimit(10);
        query.setOffset(0);
        int resultCount = query.getResultCount();
        junit.framework.Assert.assertEquals((int)50, (int)resultCount);
        List firstPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)firstPage.size());
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group Group2 : firstPage) {
            groupIds.add(Group2.getId());
        }
        query.setOffset(10);
        List secondPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)secondPage.size());
        for (Group Group3 : secondPage) {
            junit.framework.Assert.assertFalse((boolean)groupIds.contains(Group3.getId()));
            groupIds.add(Group3.getId());
        }
        query.setOffset(20);
        List thirdPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)thirdPage.size());
        for (Group Group4 : thirdPage) {
            junit.framework.Assert.assertFalse((boolean)groupIds.contains(Group4.getId()));
            groupIds.add(Group4.getId());
        }
        query.setOffset(30);
        List fourthPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)fourthPage.size());
        for (Group Group5 : fourthPage) {
            junit.framework.Assert.assertFalse((boolean)groupIds.contains(Group5.getId()));
            groupIds.add(Group5.getId());
        }
        query.setOffset(40);
        List fifthyPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)fifthyPage.size());
        for (Group Group6 : fifthyPage) {
            junit.framework.Assert.assertFalse((boolean)groupIds.contains(Group6.getId()));
            groupIds.add(Group6.getId());
        }
        junit.framework.Assert.assertEquals((int)50, (int)groupIds.size());
        query.setOffset(50);
        List invalidPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)0, (int)invalidPage.size());
    }

    @Test
    public void testFindByRealm() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        SimpleGroup someGroupDefaultRealm = new SimpleGroup("someGroupRealm");
        identityManager.add((IdentityType)someGroupDefaultRealm);
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        Realm defaultRealm = identityManager.getRealm("default");
        Assert.assertNotNull((Object)defaultRealm);
        query.setParameter(Group.PARTITION, new Object[]{defaultRealm});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someGroupDefaultRealm.getName()));
        Realm testingRealm = identityManager.getRealm("Testing");
        if (testingRealm == null) {
            testingRealm = new Realm("Testing");
            identityManager.createRealm(testingRealm);
        }
        SimpleGroup someGroupTestingRealm = new SimpleGroup("someGroupTestingRealm");
        identityManager.forRealm(testingRealm).add((IdentityType)someGroupTestingRealm);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.PARTITION, new Object[]{testingRealm});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someGroupTestingRealm.getName()));
    }

    @Test
    public void testFindByTier() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Tier someTier = new Tier("Some Group Tier");
        identityManager.createTier(someTier);
        SimpleGroup someGroupTier = new SimpleGroup("someGroupTier");
        identityManager.forTier(someTier).add((IdentityType)someGroupTier);
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        Assert.assertNotNull((Object)someTier);
        query.setParameter(Group.PARTITION, new Object[]{someTier});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someGroupTier.getName()));
        Tier someAnotherTier = new Tier("Some Another Group Tier");
        identityManager.createTier(someAnotherTier);
        SimpleGroup someGroupTestingTier = new SimpleGroup("someGroupTestingRealm");
        identityManager.forTier(someAnotherTier).add((IdentityType)someGroupTestingTier);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.PARTITION, new Object[]{someAnotherTier});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someGroupTestingTier.getName()));
    }

    @Test
    public void testFindByName() throws Exception {
        Group group = this.createGroup("admin", null);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.NAME, new Object[]{"admin"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)group.getName(), (String)((Group)result.get(0)).getName());
    }

    @Test
    public void testFindEnabledAndDisabledGroups() throws Exception {
        Group someGroup = this.createGroup("someGroup", null);
        Group someAnotherGroup = this.createGroup("someAnotherGroup", null);
        someGroup.setEnabled(true);
        someAnotherGroup.setEnabled(true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someGroup);
        identityManager.update((IdentityType)someAnotherGroup);
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.ENABLED, new Object[]{true});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)2, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherGroup.getName()));
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.ENABLED, new Object[]{false});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        someGroup.setEnabled(false);
        identityManager.update((IdentityType)someGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.ENABLED, new Object[]{false});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        someAnotherGroup.setEnabled(false);
        identityManager.update((IdentityType)someAnotherGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.ENABLED, new Object[]{true});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindWithParent() throws Exception {
        Group group = this.createGroup("someGroup", "Parent Group");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.PARENT, new Object[]{group.getParentGroup().getName()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)group.getName(), (String)((Group)result.get(0)).getName());
        junit.framework.Assert.assertEquals((String)group.getParentGroup().getName(), (String)((Group)result.get(0)).getParentGroup().getName());
    }

    @Test
    public void testFindCreationDate() throws Exception {
        Group group = this.createGroup("someGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.CREATED_DATE, new Object[]{group.getCreatedDate()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)"someGroup", (String)((Group)result.get(0)).getName());
        query = identityManager.createIdentityQuery(Group.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, 1);
        query.setParameter(Group.CREATED_DATE, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindExpiryDate() throws Exception {
        Group group = this.createGroup("someGroup", null);
        Date expirationDate = new Date();
        IdentityManager identityManager = this.getIdentityManager();
        group = identityManager.getGroup("someGroup");
        group.setExpirationDate(expirationDate);
        identityManager.update((IdentityType)group);
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.EXPIRY_DATE, new Object[]{expirationDate});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, group.getName()));
        query = identityManager.createIdentityQuery(Group.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, 1);
        query.setParameter(Group.EXPIRY_DATE, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBetweenCreationDate() throws Exception {
        Group someGroup = this.createGroup("someGroup", null);
        Group someAnotherGroup = this.createGroup("someAnotherGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        query.setParameter(Group.CREATED_AFTER, new Object[]{calendar.getTime()});
        query.setParameter(Group.CREATED_BEFORE, new Object[]{new Date()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)2, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherGroup.getName()));
        query = identityManager.createIdentityQuery(Group.class);
        Group someFutureGroup = this.createGroup("someFutureGroup", null);
        Group someAnotherFutureGroup = this.createGroup("someAnotherFutureGroup", null);
        query.setParameter(Group.CREATED_AFTER, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)4, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherGroup.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureGroup.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureGroup.getName()));
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.CREATED_BEFORE, new Object[]{new Date()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)4, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherGroup.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureGroup.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureGroup.getName()));
        query = identityManager.createIdentityQuery(Group.class);
        Calendar futureDate = Calendar.getInstance();
        futureDate.add(12, 1);
        query.setParameter(User.CREATED_AFTER, new Object[]{futureDate.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindUsingMultipleParameters() throws Exception {
        Group group = this.createGroup("admin", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)group);
        group.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        identityManager.update((IdentityType)group);
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.NAME, new Object[]{"admin"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, group.getName()));
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.NAME, new Object[]{"admin"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBetweenExpirationDate() throws Exception {
        Group someGroup = this.createGroup("someGroup", null);
        someGroup.setExpirationDate(new Date());
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someGroup);
        Group someAnotherGroup = this.createGroup("someAnotherGroup", null);
        someAnotherGroup.setExpirationDate(new Date());
        identityManager.update((IdentityType)someAnotherGroup);
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        Date expiryDate = calendar.getTime();
        query.setParameter(Group.EXPIRY_AFTER, new Object[]{expiryDate});
        query.setParameter(Group.EXPIRY_BEFORE, new Object[]{new Date()});
        Group someFutureGroup = this.createGroup("someFutureGroup", null);
        calendar = Calendar.getInstance();
        calendar.add(12, 1);
        someFutureGroup.setExpirationDate(calendar.getTime());
        identityManager.update((IdentityType)someFutureGroup);
        Group someAnotherFutureGroup = this.createGroup("someAnotherFutureGroup", null);
        someAnotherFutureGroup.setExpirationDate(calendar.getTime());
        identityManager.update((IdentityType)someAnotherFutureGroup);
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)2, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherGroup.getName()));
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.EXPIRY_AFTER, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)2, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureGroup.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureGroup.getName()));
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.EXPIRY_BEFORE, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)4, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherGroup.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureGroup.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureGroup.getName()));
        query = identityManager.createIdentityQuery(Group.class);
        Calendar futureDate = Calendar.getInstance();
        futureDate.add(12, 2);
        query.setParameter(User.EXPIRY_AFTER, new Object[]{futureDate.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindByGroupDefinedAttributes() throws Exception {
        Group someGroup = this.createGroup("someGroup", null);
        someGroup.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someGroup);
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        someGroup.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValueChanged")));
        identityManager.update((IdentityType)someGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        someGroup.setAttribute(new Attribute("someAttribute2", (Serializable)((Object)"someAttributeValue2")));
        identityManager.update((IdentityType)someGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
    }

    @Test
    public void testFindByGroupDefinedMultiValuedAttributes() throws Exception {
        Group someGroup = this.createGroup("someGroup", null);
        someGroup.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValue2"}));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someGroup);
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged", "someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        someGroup.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValueChanged"}));
        someGroup.setAttribute(new Attribute("someAttribute2", (Serializable)new String[]{"someAttribute2Value1", "someAttribute2Value2"}));
        identityManager.update((IdentityType)someGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2Value1", "someAttribute2Value2"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2ValueChanged", "someAttribute2Value2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    private boolean contains(List<Group> result, String groupName) {
        for (Group resultGroup : result) {
            if (!resultGroup.getName().equals(groupName)) continue;
            return true;
        }
        return false;
    }
}

