/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class RoleQueryTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testFindById() throws Exception {
        Role role = this.createRole("someRole");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ID, new Object[]{role.getId()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)role.getName(), (String)((Role)result.get(0)).getName());
    }

    @Test
    public void testPagination() throws Exception {
        for (int i = 0; i < 50; ++i) {
            this.createRole("someRole" + i + 1);
        }
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        query.setLimit(10);
        query.setOffset(0);
        int resultCount = query.getResultCount();
        junit.framework.Assert.assertEquals((int)50, (int)resultCount);
        List firstPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)firstPage.size());
        ArrayList<String> roleIds = new ArrayList<String>();
        for (Role Role2 : firstPage) {
            roleIds.add(Role2.getId());
        }
        query.setOffset(10);
        List secondPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)secondPage.size());
        for (Role Role3 : secondPage) {
            junit.framework.Assert.assertFalse((boolean)roleIds.contains(Role3.getId()));
            roleIds.add(Role3.getId());
        }
        query.setOffset(20);
        List thirdPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)thirdPage.size());
        for (Role Role4 : thirdPage) {
            junit.framework.Assert.assertFalse((boolean)roleIds.contains(Role4.getId()));
            roleIds.add(Role4.getId());
        }
        query.setOffset(30);
        List fourthPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)fourthPage.size());
        for (Role Role5 : fourthPage) {
            junit.framework.Assert.assertFalse((boolean)roleIds.contains(Role5.getId()));
            roleIds.add(Role5.getId());
        }
        query.setOffset(40);
        List fifthyPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)fifthyPage.size());
        for (Role Role6 : fifthyPage) {
            junit.framework.Assert.assertFalse((boolean)roleIds.contains(Role6.getId()));
            roleIds.add(Role6.getId());
        }
        junit.framework.Assert.assertEquals((int)50, (int)roleIds.size());
        query.setOffset(50);
        List invalidPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)0, (int)invalidPage.size());
    }

    @Test
    public void testFindByRealm() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        SimpleRole someRoleDefaultRealm = new SimpleRole("someRoleRealm");
        identityManager.add((IdentityType)someRoleDefaultRealm);
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        Realm defaultRealm = identityManager.getRealm("default");
        Assert.assertNotNull((Object)defaultRealm);
        query.setParameter(Role.PARTITION, new Object[]{defaultRealm});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRoleDefaultRealm.getName()));
        Realm testingRealm = identityManager.getRealm("Testing");
        if (testingRealm == null) {
            testingRealm = new Realm("Testing");
            identityManager.createRealm(testingRealm);
        }
        SimpleRole someRoleTestingRealm = new SimpleRole("someRoleTestingRealm");
        identityManager.forRealm(testingRealm).add((IdentityType)someRoleTestingRealm);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.PARTITION, new Object[]{testingRealm});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRoleTestingRealm.getName()));
    }

    @Test
    public void testFindByTier() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Tier someTier = new Tier("Some Role Tier");
        identityManager.createTier(someTier);
        SimpleRole someRoleRealm = new SimpleRole("someRoleRealm");
        identityManager.forTier(someTier).add((IdentityType)someRoleRealm);
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        Assert.assertNotNull((Object)someTier);
        query.setParameter(Role.PARTITION, new Object[]{someTier});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRoleRealm.getName()));
        Tier someAnotherTier = new Tier("Some Another Role Tier");
        identityManager.createTier(someAnotherTier);
        SimpleRole someRoleTestingTier = new SimpleRole("someRoleTestingRealm");
        identityManager.forTier(someAnotherTier).add((IdentityType)someRoleTestingTier);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.PARTITION, new Object[]{someAnotherTier});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRoleTestingTier.getName()));
    }

    @Test
    public void testFindByName() throws Exception {
        Role role = this.createRole("admin");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.NAME, new Object[]{"admin"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)role.getName(), (String)((Role)result.get(0)).getName());
    }

    @Test
    public void testFindEnabledAndDisabledRoles() throws Exception {
        Role someRole = this.createRole("someRole");
        Role someAnotherRole = this.createRole("someAnotherRole");
        someRole.setEnabled(true);
        someAnotherRole.setEnabled(true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someRole);
        identityManager.update((IdentityType)someAnotherRole);
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ENABLED, new Object[]{true});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)2, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getName()));
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ENABLED, new Object[]{false});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        someRole.setEnabled(false);
        identityManager.update((IdentityType)someRole);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ENABLED, new Object[]{false});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        someAnotherRole.setEnabled(false);
        identityManager.update((IdentityType)someAnotherRole);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ENABLED, new Object[]{true});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindCreationDate() throws Exception {
        Role role = this.createRole("someRole");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.CREATED_DATE, new Object[]{role.getCreatedDate()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)role.getName(), (String)((Role)result.get(0)).getName());
        query = identityManager.createIdentityQuery(Role.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, 1);
        query.setParameter(Role.CREATED_DATE, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindExpiryDate() throws Exception {
        Role role = this.createRole("someRole");
        Date expirationDate = new Date();
        IdentityManager identityManager = this.getIdentityManager();
        role = identityManager.getRole("someRole");
        role.setExpirationDate(expirationDate);
        identityManager.update((IdentityType)role);
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.EXPIRY_DATE, new Object[]{role.getExpirationDate()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, role.getName()));
        query = identityManager.createIdentityQuery(Role.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, 1);
        query.setParameter(Role.EXPIRY_DATE, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBetweenCreationDate() throws Exception {
        Role someRole = this.createRole("someRole");
        Role someAnotherRole = this.createRole("someAnotherRole");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        query.setParameter(Role.CREATED_AFTER, new Object[]{calendar.getTime()});
        query.setParameter(Role.CREATED_BEFORE, new Object[]{new Date()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)2, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getName()));
        query = identityManager.createIdentityQuery(Role.class);
        Role someFutureRole = this.createRole("someFutureRole");
        Role someAnotherFutureRole = this.createRole("someAnotherFutureRole");
        query.setParameter(Role.CREATED_AFTER, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)4, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureRole.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureRole.getName()));
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.CREATED_BEFORE, new Object[]{new Date()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)4, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureRole.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureRole.getName()));
        query = identityManager.createIdentityQuery(Role.class);
        Calendar futureDate = Calendar.getInstance();
        futureDate.add(12, 1);
        query.setParameter(Role.CREATED_AFTER, new Object[]{futureDate.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindUsingMultipleParameters() throws Exception {
        Role role = this.createRole("admin");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)role);
        role.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        identityManager.update((IdentityType)role);
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.NAME, new Object[]{"admin"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, role.getName()));
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.NAME, new Object[]{"admin"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBetweenExpirationDate() throws Exception {
        Role someRole = this.createRole("someRole");
        someRole.setExpirationDate(new Date());
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someRole);
        Role someAnotherRole = this.createRole("someAnotherRole");
        someAnotherRole.setExpirationDate(new Date());
        identityManager.update((IdentityType)someAnotherRole);
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        Date expiryDate = calendar.getTime();
        query.setParameter(Role.EXPIRY_AFTER, new Object[]{expiryDate});
        query.setParameter(Role.EXPIRY_BEFORE, new Object[]{new Date()});
        Role someFutureRole = this.createRole("someFutureRole");
        calendar = Calendar.getInstance();
        calendar.add(12, 1);
        someFutureRole.setExpirationDate(calendar.getTime());
        identityManager.update((IdentityType)someFutureRole);
        Role someAnotherFutureRole = this.createRole("someAnotherFutureRole");
        someAnotherFutureRole.setExpirationDate(calendar.getTime());
        identityManager.update((IdentityType)someAnotherFutureRole);
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)2, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getName()));
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.EXPIRY_AFTER, new Object[]{expiryDate});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)4, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureRole.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureRole.getName()));
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.EXPIRY_BEFORE, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)4, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureRole.getName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureRole.getName()));
        query = identityManager.createIdentityQuery(Role.class);
        Calendar futureExpiryDate = Calendar.getInstance();
        futureExpiryDate.add(12, 2);
        query.setParameter(Role.EXPIRY_AFTER, new Object[]{futureExpiryDate.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindByRoleDefinedAttributes() throws Exception {
        Role someRole = this.createRole("someRole");
        someRole.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someRole);
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        someRole.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValueChanged")));
        identityManager.update((IdentityType)someRole);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        someRole.setAttribute(new Attribute("someAttribute2", (Serializable)((Object)"someAttributeValue2")));
        identityManager.update((IdentityType)someRole);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
    }

    @Test
    public void testFindByRoleDefinedMultiValuedAttributes() throws Exception {
        Role someRole = this.createRole("someRole");
        someRole.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValue2"}));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someRole);
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged", "someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someRole.getName()));
        someRole.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValueChanged"}));
        someRole.setAttribute(new Attribute("someAttribute2", (Serializable)new String[]{"someAttribute2Value1", "someAttribute2Value2"}));
        identityManager.update((IdentityType)someRole);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2Value1", "someAttribute2Value2"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2ValueChanged", "someAttribute2Value2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    private boolean contains(List<Role> result, String roleId) {
        for (Role resultRole : result) {
            if (!resultRole.getName().equals(roleId)) continue;
            return true;
        }
        return false;
    }
}

