/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class UserQueryTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testFindById() throws Exception {
        User user = this.createUser("someUser");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.ID, new Object[]{user.getId()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((User)result.get(0)).getLoginName());
    }

    @Test
    public void testPagination() throws Exception {
        for (int i = 0; i < 50; ++i) {
            this.createUser("someUser" + i + 1);
        }
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setLimit(10);
        query.setOffset(0);
        int resultCount = query.getResultCount();
        junit.framework.Assert.assertEquals((int)50, (int)resultCount);
        List firstPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)firstPage.size());
        ArrayList<String> userIds = new ArrayList<String>();
        for (User user : firstPage) {
            userIds.add(user.getId());
        }
        query.setOffset(10);
        List secondPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)secondPage.size());
        for (User user : secondPage) {
            junit.framework.Assert.assertFalse((boolean)userIds.contains(user.getId()));
            userIds.add(user.getId());
        }
        query.setOffset(20);
        List thirdPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)thirdPage.size());
        for (User user : thirdPage) {
            junit.framework.Assert.assertFalse((boolean)userIds.contains(user.getId()));
            userIds.add(user.getId());
        }
        query.setOffset(30);
        List fourthPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)fourthPage.size());
        for (User user : fourthPage) {
            junit.framework.Assert.assertFalse((boolean)userIds.contains(user.getId()));
            userIds.add(user.getId());
        }
        query.setOffset(40);
        List fifthyPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)fifthyPage.size());
        for (User user : fifthyPage) {
            junit.framework.Assert.assertFalse((boolean)userIds.contains(user.getId()));
            userIds.add(user.getId());
        }
        query.setOffset(50);
        List invalidPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)0, (int)invalidPage.size());
    }

    @Test
    public void testFindByRealm() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        SimpleUser someUserDefaultRealm = new SimpleUser("someUserRealm");
        identityManager.add((IdentityType)someUserDefaultRealm);
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        Realm defaultRealm = identityManager.getRealm("default");
        Assert.assertNotNull((Object)defaultRealm);
        query.setParameter(User.PARTITION, new Object[]{defaultRealm});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUserDefaultRealm.getLoginName()));
        Realm testingRealm = identityManager.getRealm("Testing");
        if (testingRealm == null) {
            testingRealm = new Realm("Testing");
            identityManager.createRealm(testingRealm);
        }
        SimpleUser someUserTestingRealm = new SimpleUser("someUserTestingRealm");
        identityManager.forRealm(testingRealm).add((IdentityType)someUserTestingRealm);
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.PARTITION, new Object[]{testingRealm});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someUserDefaultRealm.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUserTestingRealm.getLoginName()));
    }

    @Test
    public void testFindByLoginName() throws Exception {
        this.createUser("admin");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.LOGIN_NAME, new Object[]{"admin"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((String)"admin", (String)((User)result.get(0)).getLoginName());
    }

    @Test
    public void testFindByFirstNameAndLastName() throws Exception {
        User user = this.createUser("admin");
        user.setFirstName("The");
        user.setLastName("Administrator");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)user);
        Assert.assertNotNull((Object)user);
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.FIRST_NAME, new Object[]{"The"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, user.getLoginName()));
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.LAST_NAME, new Object[]{"Administrator"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.FIRST_NAME, new Object[]{"The"});
        query.setParameter(User.LAST_NAME, new Object[]{"Administrator"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((String)"admin", (String)((User)result.get(0)).getLoginName());
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.FIRST_NAME, new Object[]{"The"});
        query.setParameter(User.LAST_NAME, new Object[]{"Bad Administrator"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindByEmail() throws Exception {
        User user = this.createUser("admin");
        user.setEmail("admin@jboss.org");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)user);
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.EMAIL, new Object[]{"admin@jboss.org"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((String)"admin", (String)((User)result.get(0)).getLoginName());
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.EMAIL, new Object[]{"badadmin@jboss.org"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBySingleGroupRole() throws Exception {
        User user = this.createUser("someUser");
        Group salesGroup = this.createGroup("Sales", null);
        Role managerRole = this.createRole("Manager");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.HAS_GROUP_ROLE, new Object[]{new GroupRole((IdentityType)user, salesGroup, managerRole)});
        List result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        identityManager.grantGroupRole((IdentityType)user, managerRole, salesGroup);
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.HAS_GROUP_ROLE, new Object[]{new GroupRole((IdentityType)user, salesGroup, managerRole)});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((User)result.get(0)).getLoginName());
    }

    @Test
    public void testFindBySingleGroup() throws Exception {
        User user = this.createUser("admin");
        Group administratorGroup = this.createGroup("Administrators", null);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.MEMBER_OF, new Object[]{"Administrators"});
        List result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        identityManager.addToGroup((IdentityType)user, administratorGroup);
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.MEMBER_OF, new Object[]{"Administrators"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((User)result.get(0)).getLoginName());
    }

    @Test
    public void testFindBySingleRole() throws Exception {
        User user = this.createUser("admin");
        Role administratorRole = this.createRole("Administrators");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.HAS_ROLE, new Object[]{"Administrators"});
        List result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        identityManager.grantRole((IdentityType)user, administratorRole);
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.HAS_ROLE, new Object[]{"Administrators"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((User)result.get(0)).getLoginName());
    }

    @Test
    public void testFindByMultipleGroups() throws Exception {
        User user = this.createUser("admin");
        Group administratorGroup = this.createGroup("Administrators", null);
        Group someGroup = this.createGroup("someGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((IdentityType)user, administratorGroup);
        identityManager.addToGroup((IdentityType)user, someGroup);
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.MEMBER_OF, new Object[]{administratorGroup.getName(), someGroup.getName()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((User)result.get(0)).getLoginName());
        identityManager.removeFromGroup((IdentityType)user, someGroup);
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.MEMBER_OF, new Object[]{administratorGroup.getName(), someGroup.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.MEMBER_OF, new Object[]{administratorGroup.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((User)result.get(0)).getLoginName());
    }

    @Test
    public void testFindByMultipleRoles() throws Exception {
        User user = this.createUser("admin");
        Role administratorRole = this.createRole("Administrators");
        Role someRole = this.createRole("someRole");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole((IdentityType)user, administratorRole);
        identityManager.grantRole((IdentityType)user, someRole);
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.HAS_ROLE, new Object[]{administratorRole.getName(), someRole.getName()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((User)result.get(0)).getLoginName());
        identityManager.revokeRole((IdentityType)user, someRole);
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.HAS_ROLE, new Object[]{administratorRole.getName(), someRole.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.HAS_ROLE, new Object[]{administratorRole.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)user.getLoginName(), (String)((User)result.get(0)).getLoginName());
    }

    @Test
    public void testFindByMultipleUserWithGroups() throws Exception {
        User adminUser = this.createUser("admin");
        User someUser = this.createUser("someUser");
        Group administratorGroup = this.createGroup("Administrators", null);
        Group someGroup = this.createGroup("someGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((IdentityType)adminUser, administratorGroup);
        identityManager.addToGroup((IdentityType)someUser, administratorGroup);
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.MEMBER_OF, new Object[]{administratorGroup.getName()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, adminUser.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getLoginName()));
        identityManager.addToGroup((IdentityType)adminUser, someGroup);
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.MEMBER_OF, new Object[]{administratorGroup.getName(), someGroup.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, adminUser.getLoginName()));
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someUser.getLoginName()));
    }

    @Test
    public void testFindByMultipleUserWithRoles() throws Exception {
        User adminUser = this.createUser("admin");
        User someUser = this.createUser("someUser");
        Role administratorRole = this.createRole("Administrators");
        Role someRole = this.createRole("someRole");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole((IdentityType)adminUser, administratorRole);
        identityManager.grantRole((IdentityType)someUser, administratorRole);
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.HAS_ROLE, new Object[]{administratorRole.getName()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, adminUser.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getLoginName()));
        identityManager.grantRole((IdentityType)adminUser, someRole);
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.HAS_ROLE, new Object[]{administratorRole.getName(), someRole.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, adminUser.getLoginName()));
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someUser.getLoginName()));
    }

    @Test
    public void testFindEnabledAndDisabledUsers() throws Exception {
        User someUser = this.createUser("someUser");
        User someAnotherUser = this.createUser("someAnotherUser");
        someUser.setEnabled(true);
        someAnotherUser.setEnabled(true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someUser);
        identityManager.update((IdentityType)someAnotherUser);
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.ENABLED, new Object[]{true});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherUser.getLoginName()));
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.ENABLED, new Object[]{false});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        someUser.setEnabled(false);
        identityManager.update((IdentityType)someUser);
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.ENABLED, new Object[]{false});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getLoginName()));
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someAnotherUser.getLoginName()));
        someAnotherUser.setEnabled(false);
        identityManager.update((IdentityType)someAnotherUser);
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.ENABLED, new Object[]{true});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someUser.getLoginName()));
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someAnotherUser.getLoginName()));
    }

    @Test
    public void testFindCreationDate() throws Exception {
        User user = this.createUser("someUser");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.CREATED_DATE, new Object[]{user.getCreatedDate()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((String)"someUser", (String)((User)result.get(0)).getLoginName());
        query = identityManager.createIdentityQuery(User.class);
        Calendar futureDate = Calendar.getInstance();
        futureDate.add(12, 1);
        query.setParameter(User.CREATED_DATE, new Object[]{futureDate.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindExpiryDate() throws Exception {
        User user = this.createUser("someUser");
        Date expirationDate = new Date();
        IdentityManager identityManager = this.getIdentityManager();
        user = identityManager.getUser("someUser");
        user.setExpirationDate(expirationDate);
        identityManager.update((IdentityType)user);
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.EXPIRY_DATE, new Object[]{user.getExpirationDate()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, user.getLoginName()));
        junit.framework.Assert.assertEquals((String)"someUser", (String)((User)result.get(0)).getLoginName());
        query = identityManager.createIdentityQuery(User.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, 1);
        query.setParameter(User.EXPIRY_DATE, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBetweenCreationDate() throws Exception {
        User someUser = this.createUser("someUser");
        User someAnotherUser = this.createUser("someAnotherUser");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        query.setParameter(User.CREATED_AFTER, new Object[]{calendar.getTime()});
        query.setParameter(User.CREATED_BEFORE, new Object[]{new Date()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherUser.getLoginName()));
        query = identityManager.createIdentityQuery(User.class);
        User someFutureUser = this.createUser("someFutureUser");
        User someAnotherFutureUser = this.createUser("someAnotherFutureUser");
        query.setParameter(User.CREATED_AFTER, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherUser.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureUser.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureUser.getLoginName()));
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.CREATED_BEFORE, new Object[]{new Date()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherUser.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureUser.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureUser.getLoginName()));
        query = identityManager.createIdentityQuery(User.class);
        Calendar futureDate = Calendar.getInstance();
        futureDate.add(12, 1);
        query.setParameter(User.CREATED_AFTER, new Object[]{futureDate.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindUsingMultipleParameters() throws Exception {
        User user = this.createUser("admin");
        user.setEmail("admin@jboss.org");
        user.setFirstName("The");
        user.setLastName("Administrator");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)user);
        user.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        identityManager.update((IdentityType)user);
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.EMAIL, new Object[]{"admin@jboss.org"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, user.getLoginName()));
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.EMAIL, new Object[]{"admin@jboss.org"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.EMAIL, new Object[]{"admin@jboss.org"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        query.setParameter(User.FIRST_NAME, new Object[]{"The"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, user.getLoginName()));
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.EMAIL, new Object[]{"admin@jboss.org"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        query.setParameter(User.FIRST_NAME, new Object[]{"Bad First Name"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBetweenExpirationDate() throws Exception {
        User someUser = this.createUser("someUser");
        someUser.setExpirationDate(new Date());
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someUser);
        User someAnotherUser = this.createUser("someAnotherUser");
        someAnotherUser.setExpirationDate(new Date());
        identityManager.update((IdentityType)someAnotherUser);
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        Date expiryDate = calendar.getTime();
        query.setParameter(User.EXPIRY_AFTER, new Object[]{expiryDate});
        query.setParameter(User.EXPIRY_BEFORE, new Object[]{new Date()});
        User someFutureUser = this.createUser("someFutureUser");
        someFutureUser.setExpirationDate(new Date());
        identityManager.update((IdentityType)someFutureUser);
        User someAnotherFutureUser = this.createUser("someAnotherFutureUser");
        someAnotherFutureUser.setExpirationDate(new Date());
        identityManager.update((IdentityType)someAnotherFutureUser);
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherUser.getLoginName()));
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.EXPIRY_AFTER, new Object[]{expiryDate});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherUser.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureUser.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureUser.getLoginName()));
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.EXPIRY_BEFORE, new Object[]{new Date()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherUser.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureUser.getLoginName()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureUser.getLoginName()));
        query = identityManager.createIdentityQuery(User.class);
        calendar = Calendar.getInstance();
        calendar.add(12, 2);
        query.setParameter(Agent.EXPIRY_AFTER, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindByUserDefinedAttributes() throws Exception {
        User someUser = this.createUser("someUser");
        someUser.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someUser);
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getLoginName()));
        someUser.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValueChanged")));
        identityManager.update((IdentityType)someUser);
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someUser.getLoginName()));
        someUser.setAttribute(new Attribute("someAttribute2", (Serializable)((Object)"someAttributeValue2")));
        identityManager.update((IdentityType)someUser);
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getLoginName()));
    }

    @Test
    public void testFindByUserDefinedMultiValuedAttributes() throws Exception {
        User someUser = this.createUser("someUser");
        someUser.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValue2"}));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someUser);
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getLoginName()));
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged", "someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someUser.getLoginName()));
        someUser.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValueChanged"}));
        someUser.setAttribute(new Attribute("someAttribute2", (Serializable)new String[]{"someAttribute2Value1", "someAttribute2Value2"}));
        identityManager.update((IdentityType)someUser);
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2Value1", "someAttribute2Value2"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getLoginName()));
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2ValueChanged", "someAttribute2Value2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    private boolean contains(List<User> result, String loginName) {
        for (User resultUser : result) {
            if (!resultUser.getLoginName().equals(loginName)) continue;
            return true;
        }
        return false;
    }
}

