/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.relationship;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class AgentGroupRoleRelationshipTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testGrantGroupRole() throws Exception {
        Agent developerAgent = this.createAgent("developerAgent");
        Agent projectManagerAgent = this.createAgent("projectManagerAgent");
        Role managerRole = this.createRole("Manager");
        Role developerRole = this.createRole("Developer");
        Role employeeRole = this.createRole("Employee");
        Group companyGroup = this.createGroup("Company Group", null);
        Group projectGroup = this.createGroup("Project Group", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantGroupRole((IdentityType)developerAgent, employeeRole, companyGroup);
        identityManager.grantGroupRole((IdentityType)developerAgent, developerRole, projectGroup);
        identityManager.grantGroupRole((IdentityType)projectManagerAgent, employeeRole, companyGroup);
        identityManager.grantGroupRole((IdentityType)projectManagerAgent, managerRole, projectGroup);
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole((IdentityType)developerAgent, employeeRole, companyGroup));
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole((IdentityType)developerAgent, developerRole, projectGroup));
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole((IdentityType)projectManagerAgent, employeeRole, companyGroup));
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole((IdentityType)projectManagerAgent, managerRole, projectGroup));
        Assert.assertFalse((boolean)identityManager.hasGroupRole((IdentityType)developerAgent, managerRole, projectGroup));
        Assert.assertFalse((boolean)identityManager.hasGroupRole((IdentityType)projectManagerAgent, developerRole, projectGroup));
    }

    @Test
    public void testRevokeGroupRole() throws Exception {
        Agent developerAgent = this.createAgent("developerAgent");
        Role developerRole = this.createRole("Developer");
        Role employeeRole = this.createRole("Employee");
        Group companyGroup = this.createGroup("Company Group", null);
        Group projectGroup = this.createGroup("Project Group", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantGroupRole((IdentityType)developerAgent, employeeRole, companyGroup);
        identityManager.grantGroupRole((IdentityType)developerAgent, developerRole, projectGroup);
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole((IdentityType)developerAgent, employeeRole, companyGroup));
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole((IdentityType)developerAgent, developerRole, projectGroup));
        identityManager.revokeGroupRole((IdentityType)developerAgent, developerRole, projectGroup);
        Assert.assertFalse((boolean)identityManager.hasGroupRole((IdentityType)developerAgent, developerRole, projectGroup));
    }
}

