/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.relationship;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class AgentGroupsRelationshipTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testAddAgentToGroup() throws Exception {
        Agent someAgent = this.createAgent("someAgent");
        Group someGroup = this.createGroup("someGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((IdentityType)someAgent, someGroup);
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someAgent, someGroup));
        Group someAnotherGroup = this.createGroup("someAnotherGroup", null);
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someAgent, someAnotherGroup));
        identityManager.addToGroup((IdentityType)someAgent, someAnotherGroup);
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someAgent, someAnotherGroup));
    }

    @Test
    public void testRemoveAgentFromGroup() throws Exception {
        Agent someAgent = this.createAgent("someAgent");
        Group someGroup = this.createGroup("someGroup", null);
        Group someAnotherGroup = this.createGroup("someAnotherGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((IdentityType)someAgent, someGroup);
        identityManager.addToGroup((IdentityType)someAgent, someAnotherGroup);
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someAgent, someGroup));
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someAgent, someAnotherGroup));
        identityManager.removeFromGroup((IdentityType)someAgent, someGroup);
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someAgent, someGroup));
        identityManager.removeFromGroup((IdentityType)someAgent, someAnotherGroup);
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someAgent, someAnotherGroup));
    }

    @Test
    public void testFindAgentGroups() throws Exception {
        Group someGroup = this.createGroup("someGroup", null);
        Group someAnotherGroup = this.createGroup("someAnotherGroup", null);
        Group someImportantGroup = this.createGroup("someImportantGroup", null);
        Agent user = this.createAgent("someAgent");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.removeFromGroup((IdentityType)user, someGroup);
        identityManager.removeFromGroup((IdentityType)user, someAnotherGroup);
        identityManager.removeFromGroup((IdentityType)user, someImportantGroup);
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        List result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, "someGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantGroup"));
        identityManager.addToGroup((IdentityType)user, someGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantGroup"));
        identityManager.addToGroup((IdentityType)user, someAnotherGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someGroup"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantGroup"));
        identityManager.addToGroup((IdentityType)user, someImportantGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someGroup"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertTrue((boolean)this.contains(result, "someImportantGroup"));
    }

    private boolean contains(List<Group> result, String roleId) {
        for (Group resultGroup : result) {
            if (!resultGroup.getName().equals(roleId)) continue;
            return true;
        }
        return false;
    }
}

