/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.relationship;

import java.io.Serializable;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class GroupMembershipTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testCreate() throws Exception {
        User someUser = this.getUser();
        Group someGroup = this.getGroup();
        GroupMembership groupMembership = new GroupMembership((IdentityType)someUser, someGroup);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.add((Relationship)groupMembership);
        List<GroupMembership> result = this.getGroupMembership(someUser, someGroup);
        Assert.assertEquals((long)1L, (long)result.size());
        groupMembership = result.get(0);
        Assert.assertEquals((Object)someUser.getId(), (Object)groupMembership.getMember().getId());
        Assert.assertEquals((Object)someGroup.getId(), (Object)groupMembership.getGroup().getId());
    }

    @Test
    public void testUpdate() throws Exception {
        User someUser = this.getUser();
        Group someGroup = this.getGroup();
        GroupMembership groupMembership = new GroupMembership((IdentityType)someUser, someGroup);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.add((Relationship)groupMembership);
        List<GroupMembership> result = this.getGroupMembership(someUser, someGroup);
        Assert.assertEquals((long)1L, (long)result.size());
        groupMembership = result.get(0);
        Assert.assertEquals((Object)someUser.getId(), (Object)groupMembership.getMember().getId());
        Assert.assertEquals((Object)someGroup.getId(), (Object)groupMembership.getGroup().getId());
        groupMembership.setAttribute(new Attribute("attribute1", (Serializable)((Object)"1")));
        groupMembership.setAttribute(new Attribute("attribute2", (Serializable)new String[]{"1", "2", "3"}));
        identityManager.update((Relationship)groupMembership);
        result = this.getGroupMembership(someUser, someGroup);
        Assert.assertEquals((long)1L, (long)result.size());
        groupMembership = result.get(0);
        Assert.assertEquals((Object)someUser.getId(), (Object)groupMembership.getMember().getId());
        Assert.assertEquals((Object)someGroup.getId(), (Object)groupMembership.getGroup().getId());
        Assert.assertNotNull((Object)groupMembership.getAttribute("attribute1"));
        Assert.assertNotNull((Object)groupMembership.getAttribute("attribute2"));
        Assert.assertEquals((Object)"1", (Object)groupMembership.getAttribute("attribute1").getValue());
        Assert.assertEquals((long)3L, (long)((String[])groupMembership.getAttribute("attribute2").getValue()).length);
    }

    @Test
    public void testAddUserToGroup() throws Exception {
        User someUser = this.createUser("someUser");
        Group someGroup = this.createGroup("someGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((IdentityType)someUser, someGroup);
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, someGroup));
        Group someAnotherGroup = this.createGroup("someAnotherGroup", null);
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someUser, someAnotherGroup));
        identityManager.addToGroup((IdentityType)someUser, someAnotherGroup);
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, someAnotherGroup));
    }

    @Test
    public void testRemoveUserWithRelationships() throws Exception {
        User someUser = this.createUser("someUser");
        Group someGroup = this.createGroup("someGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((IdentityType)someUser, someGroup);
        identityManager.remove((IdentityType)someUser);
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someUser, someGroup));
    }

    @Test
    public void testRemoveUserFromGroup() throws Exception {
        User someUser = this.createUser("someUser");
        Group someGroup = this.createGroup("someGroup", null);
        Group someAnotherGroup = this.createGroup("someAnotherGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((IdentityType)someUser, someGroup);
        identityManager.addToGroup((IdentityType)someUser, someAnotherGroup);
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, someGroup));
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, someAnotherGroup));
        identityManager.removeFromGroup((IdentityType)someUser, someGroup);
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someUser, someGroup));
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, someAnotherGroup));
        identityManager.removeFromGroup((IdentityType)someUser, someAnotherGroup);
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someUser, someAnotherGroup));
    }

    @Test
    public void testFindByAttributes() throws Exception {
        User someUser = this.getUser();
        Group someGroup = this.getGroup();
        GroupMembership groupMembership = new GroupMembership((IdentityType)someUser, someGroup);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.add((Relationship)groupMembership);
        RelationshipQuery query = identityManager.createRelationshipQuery(GroupMembership.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"attribute1"), new Object[]{"1"});
        List result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        groupMembership.setAttribute(new Attribute("attribute1", (Serializable)((Object)"1")));
        groupMembership.setAttribute(new Attribute("attribute2", (Serializable)new String[]{"1", "2", "3"}));
        identityManager.update((Relationship)groupMembership);
        result = query.getResultList();
        Assert.assertEquals((long)1L, (long)result.size());
        groupMembership = (GroupMembership)result.get(0);
        Assert.assertEquals((Object)someUser.getId(), (Object)groupMembership.getMember().getId());
        Assert.assertEquals((Object)someGroup.getId(), (Object)groupMembership.getGroup().getId());
        query = identityManager.createRelationshipQuery(GroupMembership.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"attribute1"), new Object[]{"2"});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createRelationshipQuery(GroupMembership.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"attribute3"), new Object[]{"2"});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createRelationshipQuery(GroupMembership.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"attribute2"), new Object[]{"1", "2", "3"});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
    }

    @Test
    public void testFindUserGroups() throws Exception {
        Group someGroup = this.createGroup("someGroup", null);
        Group someAnotherGroup = this.createGroup("someAnotherGroup", null);
        Group someImportantGroup = this.createGroup("someImportantGroup", null);
        User user = this.createUser("someUser");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.removeFromGroup((IdentityType)user, someGroup);
        identityManager.removeFromGroup((IdentityType)user, someAnotherGroup);
        identityManager.removeFromGroup((IdentityType)user, someImportantGroup);
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        List result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, "someGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantGroup"));
        identityManager.addToGroup((IdentityType)user, someGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantGroup"));
        identityManager.addToGroup((IdentityType)user, someAnotherGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someGroup"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantGroup"));
        identityManager.addToGroup((IdentityType)user, someImportantGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someGroup"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertTrue((boolean)this.contains(result, "someImportantGroup"));
    }

    private Group getGroup() {
        return this.createGroup("someGroup", null);
    }

    private User getUser() {
        return this.createUser("someUser");
    }

    private List<GroupMembership> getGroupMembership(User someUser, Group someGroup) {
        IdentityManager identityManager = this.getIdentityManager();
        RelationshipQuery query = identityManager.createRelationshipQuery(GroupMembership.class);
        query.setParameter((QueryParameter)GroupMembership.MEMBER, new Object[]{someUser});
        query.setParameter((QueryParameter)GroupMembership.GROUP, new Object[]{someGroup});
        return query.getResultList();
    }

    private boolean contains(List<Group> result, String roleId) {
        for (Group resultGroup : result) {
            if (!resultGroup.getName().equals(roleId)) continue;
            return true;
        }
        return false;
    }
}

