/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.relationship;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class UserGroupRoleRelationshipTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testGrantGroupRole() throws Exception {
        User developerUser = this.createUser("developerUser");
        User projectManagerUser = this.createUser("projectManagerUser");
        Role managerRole = this.createRole("Manager");
        Role developerRole = this.createRole("Developer");
        Role employeeRole = this.createRole("Employee");
        Group companyGroup = this.createGroup("Company Group", null);
        Group projectGroup = this.createGroup("Project Group", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantGroupRole((IdentityType)developerUser, employeeRole, companyGroup);
        identityManager.grantGroupRole((IdentityType)developerUser, developerRole, projectGroup);
        identityManager.grantGroupRole((IdentityType)projectManagerUser, employeeRole, companyGroup);
        identityManager.grantGroupRole((IdentityType)projectManagerUser, managerRole, projectGroup);
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole((IdentityType)developerUser, employeeRole, companyGroup));
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole((IdentityType)developerUser, developerRole, projectGroup));
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole((IdentityType)projectManagerUser, employeeRole, companyGroup));
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole((IdentityType)projectManagerUser, managerRole, projectGroup));
        Assert.assertFalse((boolean)identityManager.hasGroupRole((IdentityType)developerUser, managerRole, projectGroup));
        Assert.assertFalse((boolean)identityManager.hasGroupRole((IdentityType)projectManagerUser, developerRole, projectGroup));
    }

    @Test
    public void testRevokeGroupRole() throws Exception {
        User developerUser = this.createUser("developerUser");
        Role developerRole = this.createRole("Developer");
        Role employeeRole = this.createRole("Employee");
        Group companyGroup = this.createGroup("Company Group", null);
        Group projectGroup = this.createGroup("Project Group", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantGroupRole((IdentityType)developerUser, employeeRole, companyGroup);
        identityManager.grantGroupRole((IdentityType)developerUser, developerRole, projectGroup);
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole((IdentityType)developerUser, employeeRole, companyGroup));
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole((IdentityType)developerUser, developerRole, projectGroup));
        identityManager.revokeGroupRole((IdentityType)developerUser, developerRole, projectGroup);
        Assert.assertFalse((boolean)identityManager.hasGroupRole((IdentityType)developerUser, developerRole, projectGroup));
    }
}

