/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.relationship;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class UserRolesRelationshipTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testGrantRoleToUser() throws Exception {
        User someUser = this.createUser("someUser");
        Role someRole = this.createRole("someRole");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole((IdentityType)someUser, someRole);
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someUser, someRole));
        Role someAnotherRole = this.createRole("someAnotherRole");
        Assert.assertFalse((boolean)identityManager.hasRole((IdentityType)someUser, someAnotherRole));
        identityManager.grantRole((IdentityType)someUser, someAnotherRole);
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someUser, someAnotherRole));
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someUser, someRole));
    }

    @Test
    public void testRevokeRoleFromUser() throws Exception {
        User someUser = this.createUser("someUser");
        Role someRole = this.createRole("someRole");
        Role someAnotherRole = this.createRole("someAnotherRole");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole((IdentityType)someUser, someRole);
        identityManager.grantRole((IdentityType)someUser, someAnotherRole);
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someUser, someRole));
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someUser, someAnotherRole));
        identityManager.revokeRole((IdentityType)someUser, someRole);
        Assert.assertFalse((boolean)identityManager.hasRole((IdentityType)someUser, someRole));
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someUser, someAnotherRole));
        identityManager.revokeRole((IdentityType)someUser, someAnotherRole);
        Assert.assertFalse((boolean)identityManager.hasRole((IdentityType)someUser, someAnotherRole));
    }

    @Test
    public void testFindUserRoles() throws Exception {
        Role someRole = this.createRole("someRole");
        Role someAnotherRole = this.createRole("someAnotherRole");
        Role someImportantRole = this.createRole("someImportantRole");
        User user = this.createUser("someUser");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.revokeRole((IdentityType)user, someRole);
        identityManager.revokeRole((IdentityType)user, someAnotherRole);
        identityManager.revokeRole((IdentityType)user, someImportantRole);
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        List result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, "someRole"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherRole"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantRole"));
        identityManager.grantRole((IdentityType)user, someRole);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someRole"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherRole"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantRole"));
        identityManager.grantRole((IdentityType)user, someAnotherRole);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someRole"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherRole"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantRole"));
        identityManager.grantRole((IdentityType)user, someImportantRole);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someRole"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherRole"));
        Assert.assertTrue((boolean)this.contains(result, "someImportantRole"));
        identityManager.revokeRole((IdentityType)user, someRole);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertFalse((boolean)this.contains(result, "someRole"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherRole"));
        Assert.assertTrue((boolean)this.contains(result, "someImportantRole"));
    }

    private boolean contains(List<Role> result, String roleId) {
        for (Role resultRole : result) {
            if (!resultRole.getName().equals(roleId)) continue;
            return true;
        }
        return false;
    }
}

