/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.usecases;

import java.io.Serializable;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.Authorization;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.SimpleAgent;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class ApplicationUserRelationshipTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void authorizeAccess() throws Exception {
        String authorizationCode = "ac";
        String accessToken = "at";
        String refreshToken = "rt";
        IdentityManager identityManager = this.getIdentityManager();
        User robert = this.createUser("robert");
        SimpleAgent myOauthApp = new SimpleAgent("My OAuth App");
        identityManager.add((IdentityType)myOauthApp);
        Authorization authorized = new Authorization(robert, (Agent)myOauthApp);
        authorized.setAttribute(new Attribute("authorizationCode", (Serializable)((Object)authorizationCode)));
        authorized.setAttribute(new Attribute("accessToken", (Serializable)((Object)accessToken)));
        authorized.setAttribute(new Attribute("refreshToken", (Serializable)((Object)refreshToken)));
        identityManager.add((Relationship)authorized);
        RelationshipQuery query = identityManager.createRelationshipQuery(Authorization.class);
        query.setParameter((QueryParameter)Authorization.USER, new Object[]{robert});
        query.setParameter((QueryParameter)Authorization.APPLICATION, new Object[]{myOauthApp});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        authorized = (Authorization)result.get(0);
        Assert.assertNotNull((Object)authorized.getUser());
        Assert.assertNotNull((Object)authorized.getApplication());
        Assert.assertNotNull((Object)authorized.getAttribute("authorizationCode"));
        query = identityManager.createRelationshipQuery(Authorization.class);
        query.setParameter((QueryParameter)Authorization.APPLICATION, new Object[]{myOauthApp});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)authorized.getUser());
        Assert.assertNotNull((Object)authorized.getApplication());
        query = identityManager.createRelationshipQuery(Authorization.class);
        query.setParameter((QueryParameter)Authorization.USER, new Object[]{robert});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)authorized.getUser());
        Assert.assertNotNull((Object)authorized.getApplication());
        User someUser = this.createUser("someUser");
        query = identityManager.createRelationshipQuery(Authorization.class);
        query.setParameter((QueryParameter)Authorization.USER, new Object[]{someUser});
        query.setParameter((QueryParameter)Authorization.APPLICATION, new Object[]{myOauthApp});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        identityManager.remove((Relationship)authorized);
        query = identityManager.createRelationshipQuery(Authorization.class);
        query.setParameter((QueryParameter)Authorization.USER, new Object[]{robert});
        query.setParameter((QueryParameter)Authorization.APPLICATION, new Object[]{myOauthApp});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }
}

