/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import java.util.Date;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.SecurityContext;

public final class CredentialUtils {
    public static boolean isCurrentCredential(CredentialStorage credential) {
        boolean isCurrent = true;
        Date actualDate = new Date();
        if (credential.getEffectiveDate() != null && credential.getEffectiveDate().compareTo(actualDate) > 0) {
            isCurrent = false;
        }
        if (isCurrent && credential.getExpiryDate() != null && credential.getExpiryDate().compareTo(actualDate) <= 0) {
            isCurrent = false;
        }
        return isCurrent;
    }

    public static boolean isLastCredentialExpired(SecurityContext context, Agent agent, CredentialStore store, Class<? extends CredentialStorage> storageClass) {
        return CredentialUtils.isCredentialExpired(CredentialUtils.getCurrentCredential(context, agent, store, storageClass));
    }

    public static <T extends CredentialStorage> T getCurrentCredential(SecurityContext context, Agent agent, CredentialStore store, Class<T> storageClass) {
        CredentialStorage lastCredential = null;
        Date actualDate = new Date();
        for (CredentialStorage storedCredential : store.retrieveCredentials(context, agent, storageClass)) {
            if (storedCredential.getEffectiveDate().compareTo(actualDate) > 0 || lastCredential != null && lastCredential.getEffectiveDate().compareTo(storedCredential.getEffectiveDate()) > 0) continue;
            lastCredential = storedCredential;
        }
        return (T)lastCredential;
    }

    public static boolean isCredentialExpired(CredentialStorage credentialStorage) {
        return credentialStorage != null && credentialStorage.getExpiryDate() != null && new Date().compareTo(credentialStorage.getExpiryDate()) > 0;
    }
}

