/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import java.util.HashMap;
import java.util.Map;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialHandlerFactory;
import org.picketlink.idm.credential.spi.annotations.CredentialHandlers;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.spi.IdentityStore;

public class DefaultCredentialHandlerFactory
implements CredentialHandlerFactory {
    Map<Class<? extends CredentialHandler>, CredentialHandler> handlerInstances = new HashMap<Class<? extends CredentialHandler>, CredentialHandler>();

    public CredentialHandler getCredentialValidator(Class<? extends Credentials> credentialsClass, Class<? extends IdentityStore> identityStoreClass) {
        CredentialHandlers handlers = identityStoreClass.getAnnotation(CredentialHandlers.class);
        for (Class handlerClass : handlers.value()) {
            if (!this.handlerSupports(handlerClass, credentialsClass)) continue;
            if (!this.handlerInstances.containsKey(handlerClass)) {
                return this.createHandlerInstance(handlerClass);
            }
            return this.handlerInstances.get(handlerClass);
        }
        return null;
    }

    public CredentialHandler getCredentialUpdater(Class<?> credentialClass, Class<? extends IdentityStore> identityStoreClass) {
        CredentialHandlers handlers = identityStoreClass.getAnnotation(CredentialHandlers.class);
        for (Class handlerClass : handlers.value()) {
            if (!this.handlerSupports(handlerClass, credentialClass)) continue;
            if (!this.handlerInstances.containsKey(handlerClass)) {
                return this.createHandlerInstance(handlerClass);
            }
            return this.handlerInstances.get(handlerClass);
        }
        return null;
    }

    private synchronized CredentialHandler createHandlerInstance(Class<? extends CredentialHandler> handlerClass) {
        CredentialHandler handler = null;
        if (!this.handlerInstances.containsKey(handlerClass)) {
            try {
                handler = handlerClass.newInstance();
                this.handlerInstances.put(handlerClass, handler);
            }
            catch (Exception ex) {
                throw IDMMessages.MESSAGES.credentialCredentialHandlerInstantiationError(handlerClass, (Throwable)ex);
            }
        } else {
            handler = this.handlerInstances.get(handlerClass);
        }
        return handler;
    }

    private boolean handlerSupports(Class<? extends CredentialHandler> handlerClass, Class<?> credentialClass) {
        SupportsCredentials sc = handlerClass.getAnnotation(SupportsCredentials.class);
        for (Class cls : sc.value()) {
            if (!cls.equals(credentialClass)) continue;
            return true;
        }
        return false;
    }
}

