/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import java.util.Date;
import java.util.List;
import org.picketlink.common.util.Base64;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Digest;
import org.picketlink.idm.credential.DigestCredentials;
import org.picketlink.idm.credential.internal.CredentialUtils;
import org.picketlink.idm.credential.internal.DigestCredentialStorage;
import org.picketlink.idm.credential.internal.DigestUtil;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.SecurityContext;

@SupportsCredentials(value={DigestCredentials.class, Digest.class})
public class DigestCredentialHandler
implements CredentialHandler {
    public void validate(SecurityContext context, Credentials credentials, IdentityStore<?> identityStore) {
        CredentialStore credentialStore = this.validateCredentialStore(identityStore);
        if (!DigestCredentials.class.isInstance(credentials)) {
            throw IDMMessages.MESSAGES.credentialUnsupportedType(credentials.getClass(), (CredentialHandler)this);
        }
        DigestCredentials digestCredential = (DigestCredentials)credentials;
        digestCredential.setStatus(Credentials.Status.INVALID);
        Digest digest = digestCredential.getDigest();
        Agent agent = identityStore.getAgent(context, digest.getUsername());
        if (agent != null) {
            List storages = credentialStore.retrieveCredentials(context, agent, DigestCredentialStorage.class);
            DigestCredentialStorage currentCredential = null;
            for (DigestCredentialStorage storage : storages) {
                if (!storage.getRealm().equals(digest.getRealm()) || !CredentialUtils.isCurrentCredential(storage)) continue;
                currentCredential = storage;
                break;
            }
            if (currentCredential != null) {
                if (digest.getMethod() != null && digest.getUri() != null) {
                    byte[] ha2;
                    byte[] storedHA1 = currentCredential.getHa1();
                    String calculateDigest = DigestUtil.calculateDigest(digest, storedHA1, ha2 = DigestUtil.calculateA2(digest.getMethod(), digest.getUri()));
                    if (calculateDigest.equals(digest.getDigest())) {
                        digestCredential.setStatus(Credentials.Status.VALID);
                    }
                } else {
                    String storedDigestPassword = Base64.encodeBytes((byte[])currentCredential.getHa1());
                    String providedDigest = digest.getDigest();
                    if (String.valueOf(storedDigestPassword).equals(providedDigest)) {
                        digestCredential.setStatus(Credentials.Status.VALID);
                    }
                }
            } else if (CredentialUtils.isLastCredentialExpired(context, agent, credentialStore, DigestCredentialStorage.class)) {
                digestCredential.setStatus(Credentials.Status.EXPIRED);
            }
            if (digestCredential.getStatus().equals((Object)Credentials.Status.VALID)) {
                digestCredential.setValidatedAgent(agent);
            }
        }
    }

    public void update(SecurityContext context, Agent agent, Object credential, IdentityStore<?> identityStore, Date effectiveDate, Date expiryDate) {
        CredentialStore credentialStore = this.validateCredentialStore(identityStore);
        if (!Digest.class.isInstance(credential)) {
            throw IDMMessages.MESSAGES.credentialUnsupportedType(credential.getClass(), (CredentialHandler)this);
        }
        Digest digestCredential = (Digest)credential;
        if (StringUtil.isNullOrEmpty((String)digestCredential.getRealm())) {
            throw IDMMessages.MESSAGES.credentialDigestInvalidRealm();
        }
        if (StringUtil.isNullOrEmpty((String)digestCredential.getPassword())) {
            throw IDMMessages.MESSAGES.credentialInvalidPassword();
        }
        byte[] ha1 = DigestUtil.calculateA1(agent.getLoginName(), digestCredential.getRealm(), digestCredential.getPassword().toCharArray());
        DigestCredentialStorage storage = new DigestCredentialStorage(ha1, digestCredential.getRealm());
        storage.setEffectiveDate(effectiveDate);
        storage.setExpiryDate(expiryDate);
        credentialStore.storeCredential(context, agent, (CredentialStorage)storage);
    }

    private CredentialStore validateCredentialStore(IdentityStore<?> identityStore) {
        if (!CredentialStore.class.isInstance(identityStore)) {
            throw IDMMessages.MESSAGES.credentialInvalidCredentialStoreType(identityStore.getClass());
        }
        return (CredentialStore)identityStore;
    }
}

