/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import java.util.Date;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.credential.internal.CredentialUtils;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.password.internal.SHASaltedPasswordEncoder;
import org.picketlink.idm.password.internal.SHASaltedPasswordStorage;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.SecurityContext;

@SupportsCredentials(value={UsernamePasswordCredentials.class, Password.class})
public class PasswordCredentialHandler
implements CredentialHandler {
    public void validate(SecurityContext context, Credentials credentials, IdentityStore<?> identityStore) {
        SHASaltedPasswordStorage hash;
        CredentialStore store = this.validateCredentialStore(identityStore);
        if (!UsernamePasswordCredentials.class.isInstance(credentials)) {
            throw IDMMessages.MESSAGES.credentialUnsupportedType(credentials.getClass(), (CredentialHandler)this);
        }
        UsernamePasswordCredentials usernamePassword = (UsernamePasswordCredentials)credentials;
        usernamePassword.setStatus(Credentials.Status.INVALID);
        Agent agent = identityStore.getAgent(context, usernamePassword.getUsername());
        if (agent != null && (hash = (SHASaltedPasswordStorage)store.retrieveCurrentCredential(context, agent, SHASaltedPasswordStorage.class)) != null) {
            if (!CredentialUtils.isCredentialExpired(hash)) {
                SHASaltedPasswordEncoder encoder = new SHASaltedPasswordEncoder(512);
                String encoded = encoder.encodePassword(hash.getSalt(), new String(usernamePassword.getPassword().getValue()));
                if (hash.getEncodedHash().equals(encoded)) {
                    usernamePassword.setStatus(Credentials.Status.VALID);
                    usernamePassword.setValidatedAgent(agent);
                }
            } else {
                usernamePassword.setStatus(Credentials.Status.EXPIRED);
            }
        }
    }

    public void update(SecurityContext context, Agent agent, Object credential, IdentityStore<?> identityStore, Date effectiveDate, Date expiryDate) {
        CredentialStore store = this.validateCredentialStore(identityStore);
        if (!Password.class.isInstance(credential)) {
            throw IDMMessages.MESSAGES.credentialUnsupportedType(credential.getClass(), (CredentialHandler)this);
        }
        Password password = (Password)credential;
        SHASaltedPasswordEncoder encoder = new SHASaltedPasswordEncoder(512);
        SHASaltedPasswordStorage hash = new SHASaltedPasswordStorage();
        hash.setEncodedHash(encoder.encodePassword(hash.getSalt(), new String(password.getValue())));
        hash.setEffectiveDate(effectiveDate);
        if (expiryDate != null) {
            hash.setExpiryDate(expiryDate);
        }
        store.storeCredential(context, agent, (CredentialStorage)hash);
    }

    private CredentialStore validateCredentialStore(IdentityStore<?> identityStore) {
        if (!CredentialStore.class.isInstance(identityStore)) {
            throw IDMMessages.MESSAGES.credentialInvalidCredentialStoreType(identityStore.getClass());
        }
        return (CredentialStore)identityStore;
    }
}

