/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.internal.CredentialUtils;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.Stored;
import org.picketlink.idm.file.internal.FileBasedIdentityStore;
import org.picketlink.idm.file.internal.FileCredentialStorage;
import org.picketlink.idm.file.internal.FileDataSource;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.SecurityContext;

public class FileCredentialStore
implements CredentialStore {
    private FileBasedIdentityStore identityStore;

    public FileCredentialStore(FileBasedIdentityStore identityStore) {
        this.identityStore = identityStore;
    }

    public void validateCredentials(SecurityContext context, Credentials credentials) {
        CredentialHandler handler = context.getCredentialValidator(credentials.getClass(), (IdentityStore)this.identityStore);
        if (handler == null) {
            throw IDMMessages.MESSAGES.credentialHandlerNotFoundForCredentialType(credentials.getClass());
        }
        handler.validate(context, credentials, (IdentityStore)this.identityStore);
    }

    public void updateCredential(SecurityContext context, Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        CredentialHandler handler = context.getCredentialUpdater(credential.getClass(), (IdentityStore)this.identityStore);
        if (handler == null) {
            throw IDMMessages.MESSAGES.credentialHandlerNotFoundForCredentialType(credential.getClass());
        }
        handler.update(context, agent, credential, (IdentityStore)this.identityStore, effectiveDate, expiryDate);
    }

    public void storeCredential(SecurityContext context, Agent agent, CredentialStorage storage) {
        List<FileCredentialStorage> credentials = this.getCredentials(context, agent, storage.getClass());
        FileCredentialStorage credential = new FileCredentialStorage();
        List annotatedTypes = PropertyQueries.createQuery(storage.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(Stored.class)).getResultList();
        for (Property property : annotatedTypes) {
            credential.getStoredFields().put(property.getName(), (Serializable)property.getValue((Object)storage));
        }
        if (credential.getEffectiveDate() == null) {
            credential.setEffectiveDate(new Date());
        }
        credentials.add(credential);
        this.flushCredentials(context);
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(SecurityContext context, Agent agent, Class<T> storageClass) {
        return CredentialUtils.getCurrentCredential(context, agent, this, storageClass);
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(SecurityContext context, Agent agent, Class<T> storageTyper) {
        ArrayList<T> storedCredentials = new ArrayList<T>();
        List<FileCredentialStorage> credentials = this.getCredentials(context, agent, storageTyper);
        for (FileCredentialStorage fileCredentialStorage : credentials) {
            storedCredentials.add(this.convertToCredentialStorage(storageTyper, fileCredentialStorage));
        }
        return storedCredentials;
    }

    public void removeCredentials(SecurityContext context, Agent agent) {
        this.getCredentialsForCurrentPartition(context).remove(agent.getLoginName());
        this.flushCredentials(context);
    }

    private <T extends CredentialStorage> T convertToCredentialStorage(Class<T> storageClass, FileCredentialStorage fileCredentialStorage) {
        CredentialStorage storage = null;
        try {
            storage = (CredentialStorage)storageClass.newInstance();
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.instantiationError(storageClass.getName(), (Throwable)e);
        }
        Set<Map.Entry<String, Serializable>> storedFields = fileCredentialStorage.getStoredFields().entrySet();
        for (Map.Entry<String, Serializable> storedField : storedFields) {
            List annotatedTypes = PropertyQueries.createQuery(storageClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{storedField.getKey()})).getResultList();
            if (annotatedTypes.isEmpty()) {
                throw new IdentityManagementException("Could not find property [" + storedField.getKey() + "] on CredentialStorage [" + storageClass.getName() + "].");
            }
            if (annotatedTypes.size() > 1) {
                throw new IdentityManagementException("Ambiguos property [" + storedField.getKey() + "] on CredentialStorage [" + storageClass.getName() + "].");
            }
            ((Property)annotatedTypes.get(0)).setValue((Object)storage, (Object)storedField.getValue());
        }
        return (T)storage;
    }

    private List<FileCredentialStorage> getCredentials(SecurityContext context, Agent agent, Class<? extends CredentialStorage> storageType) {
        List<FileCredentialStorage> credentials;
        Map<String, List<FileCredentialStorage>> agentCredentials = this.getCredentialsForCurrentPartition(context).get(agent.getLoginName());
        if (agentCredentials == null) {
            agentCredentials = new HashMap<String, List<FileCredentialStorage>>();
        }
        if ((credentials = agentCredentials.get(storageType.getName())) == null) {
            credentials = new ArrayList<FileCredentialStorage>();
        }
        agentCredentials.put(storageType.getName(), credentials);
        this.getCredentialsForCurrentPartition(context).put(agent.getLoginName(), agentCredentials);
        return credentials;
    }

    private Map<String, Map<String, List<FileCredentialStorage>>> getCredentialsForCurrentPartition(SecurityContext context) {
        if (Realm.class.isInstance(context.getPartition())) {
            Realm realm = (Realm)context.getPartition();
            return this.getDataSource().getCredentials(realm);
        }
        throw new RuntimeException();
    }

    private void flushCredentials(SecurityContext context) {
        if (!Realm.class.isInstance(context.getPartition())) {
            throw new RuntimeException();
        }
        Realm realm = (Realm)context.getPartition();
        this.getDataSource().flushCredentials(realm);
    }

    private FileDataSource getDataSource() {
        return this.identityStore.getDataSource();
    }
}

