/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.HashMap;
import java.util.Map;
import org.picketlink.idm.IdentityCache;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;

public class DefaultIdentityCache
implements IdentityCache {
    private Map<Partition, Map<String, Agent>> agentsCache = new HashMap<Partition, Map<String, Agent>>();
    private Map<Partition, Map<String, Role>> rolesCache = new HashMap<Partition, Map<String, Role>>();
    private Map<Partition, Map<String, Group>> groupsCache = new HashMap<Partition, Map<String, Group>>();

    public User lookupUser(Realm realm, String loginName) {
        Agent agent = this.lookupAgent(realm, loginName);
        if (User.class.isInstance(agent)) {
            return (User)agent;
        }
        return null;
    }

    public Group lookupGroup(Partition partition, String groupPath) {
        return this.getGroups(partition).get(groupPath);
    }

    public Role lookupRole(Partition partition, String name) {
        return this.getRoles(partition).get(name);
    }

    public void putUser(Realm realm, User user) {
        this.putAgent(realm, (Agent)user);
    }

    public void putGroup(Partition partition, Group group) {
        this.getGroups(partition).get(group.getPath());
    }

    public void putRole(Partition partition, Role role) {
        this.getRoles(partition).put(role.getName(), role);
    }

    public Agent lookupAgent(Realm realm, String loginName) {
        return this.getAgents(realm).get(loginName);
    }

    public void putAgent(Realm realm, Agent agent) {
        this.getAgents(realm).get(agent.getLoginName());
    }

    public void invalidate(Partition partition, IdentityType identityType) {
        if (Agent.class.isInstance(identityType)) {
            Agent agent = (Agent)identityType;
            this.getAgents((Realm)partition).remove(agent.getLoginName());
        } else if (Role.class.isInstance(identityType)) {
            Role role = (Role)identityType;
            this.getRoles(partition).remove(role.getName());
        } else if (Group.class.isInstance(identityType)) {
            Group group = (Group)identityType;
            this.getGroups(partition).remove(group.getPath());
        }
    }

    private Map<String, Agent> getAgents(Realm realm) {
        Map<String, Agent> agents = this.agentsCache.get(realm);
        if (agents == null) {
            agents = new HashMap<String, Agent>();
            this.agentsCache.put((Partition)realm, agents);
        }
        return agents;
    }

    private Map<String, Role> getRoles(Partition partition) {
        Map<String, Role> roles = this.rolesCache.get(partition);
        if (roles == null) {
            roles = new HashMap<String, Role>();
            this.rolesCache.put(partition, roles);
        }
        return roles;
    }

    private Map<String, Group> getGroups(Partition partition) {
        Map<String, Group> groups = this.groupsCache.get(partition);
        if (groups == null) {
            groups = new HashMap<String, Group>();
            this.groupsCache.put(partition, groups);
        }
        return groups;
    }
}

