/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.Date;
import java.util.List;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.internal.DefaultIdentityQuery;
import org.picketlink.idm.query.internal.DefaultRelationshipQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.SecurityContext;
import org.picketlink.idm.spi.StoreFactory;

public class DefaultIdentityManager
implements IdentityManager {
    private static final long serialVersionUID = -2835518073812662628L;
    private SecurityContext context;
    private StoreFactory storeFactory;

    public DefaultIdentityManager(SecurityContext context, StoreFactory storeFactory) {
        this.context = context;
        this.storeFactory = storeFactory;
        context.setIdentityManager((IdentityManager)this);
    }

    public void add(IdentityType identityType) {
        if (identityType == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityType");
        }
        if (Agent.class.isInstance(identityType)) {
            this.checkCurrentPartitionForAgents();
            Agent newAgent = (Agent)identityType;
            if (StringUtil.isNullOrEmpty((String)newAgent.getLoginName())) {
                throw IDMMessages.MESSAGES.nullArgument("User loginName");
            }
            if (User.class.isInstance(newAgent) ? this.getUser(newAgent.getLoginName()) != null : this.getAgent(newAgent.getLoginName()) != null) {
                throw IDMMessages.MESSAGES.identityTypeAlreadyExists(newAgent.getClass(), newAgent.getLoginName(), this.context.getPartition());
            }
        } else if (Group.class.isInstance(identityType)) {
            Group newGroup = (Group)identityType;
            if (StringUtil.isNullOrEmpty((String)newGroup.getName())) {
                throw IDMMessages.MESSAGES.nullArgument("Group name");
            }
            if (this.getGroup(newGroup.getPath()) != null) {
                throw IDMMessages.MESSAGES.identityTypeAlreadyExists(newGroup.getClass(), newGroup.getName(), this.context.getPartition());
            }
            if (newGroup.getParentGroup() != null && this.lookupIdentityById(Group.class, newGroup.getParentGroup().getId()) == null) {
                throw IDMMessages.MESSAGES.groupParentNotFoundWithId(newGroup.getParentGroup().getId(), this.context.getPartition());
            }
        } else if (Role.class.isInstance(identityType)) {
            Role newRole = (Role)identityType;
            if (StringUtil.isNullOrEmpty((String)newRole.getName())) {
                throw IDMMessages.MESSAGES.nullArgument("Role name");
            }
            if (this.getRole(newRole.getName()) != null) {
                throw IDMMessages.MESSAGES.identityTypeAlreadyExists(newRole.getClass(), newRole.getName(), this.context.getPartition());
            }
        }
        try {
            this.storeFactory.getStoreForFeature(this.context, IDMUtil.getFeatureGroup(identityType), FeatureSet.FeatureOperation.create).add(this.context, (AttributedType)identityType);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.identityTypeAddFailed(identityType, (Throwable)e);
        }
    }

    public void add(Relationship relationship) {
        try {
            this.storeFactory.getStoreForFeature(this.context, FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.create, relationship.getClass()).add(this.context, (AttributedType)relationship);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.relationshipAddFailed(relationship, (Throwable)e);
        }
    }

    public void update(IdentityType identityType) {
        this.checkIfIdentityTypeExists(identityType);
        if (Agent.class.isInstance(identityType)) {
            this.checkCurrentPartitionForAgents();
        }
        try {
            this.storeFactory.getStoreForFeature(this.context, IDMUtil.getFeatureGroup(identityType), FeatureSet.FeatureOperation.update).update(this.context, (AttributedType)identityType);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.identityTypeUpdateFailed(identityType, (Throwable)e);
        }
    }

    public void update(Relationship relationship) {
        try {
            this.storeFactory.getStoreForFeature(this.context, FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.update, relationship.getClass()).update(this.context, (AttributedType)relationship);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.relationshipUpdateFailed(relationship, (Throwable)e);
        }
    }

    public void remove(IdentityType identityType) {
        this.checkIfIdentityTypeExists(identityType);
        if (Agent.class.isInstance(identityType)) {
            this.checkCurrentPartitionForAgents();
        }
        try {
            this.storeFactory.getStoreForFeature(this.context, IDMUtil.getFeatureGroup(identityType), FeatureSet.FeatureOperation.delete).remove(this.context, (AttributedType)identityType);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.identityTypeUpdateFailed(identityType, (Throwable)e);
        }
    }

    public void remove(Relationship relationship) {
        if (relationship == null) {
            IDMMessages.MESSAGES.nullArgument("Relationship");
        }
        try {
            this.storeFactory.getStoreForFeature(this.context, FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.delete, relationship.getClass()).remove(this.context, (AttributedType)relationship);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.relationshipRemoveFailed(relationship, (Throwable)e);
        }
    }

    public Agent getAgent(String loginName) {
        this.checkCurrentPartitionForAgents();
        return this.storeFactory.getStoreForFeature(this.context, FeatureSet.FeatureGroup.agent, FeatureSet.FeatureOperation.read).getAgent(this.context, loginName);
    }

    public User getUser(String loginName) {
        this.checkCurrentPartitionForAgents();
        return this.storeFactory.getStoreForFeature(this.context, FeatureSet.FeatureGroup.user, FeatureSet.FeatureOperation.read).getUser(this.context, loginName);
    }

    public Group getGroup(String path) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            return null;
        }
        return this.storeFactory.getStoreForFeature(this.context, FeatureSet.FeatureGroup.group, FeatureSet.FeatureOperation.read).getGroup(this.context, path);
    }

    public Group getGroup(String name, Group parent) {
        if (StringUtil.isNullOrEmpty((String)name) || parent == null) {
            return null;
        }
        if (this.lookupIdentityById(Group.class, parent.getId()) == null) {
            throw IDMMessages.MESSAGES.groupParentNotFoundWithId(parent.getId(), this.context.getPartition());
        }
        return this.storeFactory.getStoreForFeature(this.context, FeatureSet.FeatureGroup.group, FeatureSet.FeatureOperation.read).getGroup(this.context, name, parent);
    }

    public boolean isMember(IdentityType identityType, Group group) {
        if (identityType == null) {
            IDMMessages.MESSAGES.nullArgument("IdentityType");
        }
        if (group == null) {
            IDMMessages.MESSAGES.nullArgument("Group");
        }
        boolean isMember = false;
        if (Agent.class.isInstance(identityType)) {
            isMember = this.getGroupMembership(identityType, group) != null;
        } else if (Group.class.isInstance(identityType)) {
            Group memberGroup = (Group)identityType;
            if (memberGroup.getId() != null && (memberGroup = this.lookupIdentityById(Group.class, memberGroup.getId())) != null) {
                isMember = memberGroup.getPath().contains(group.getPath());
            }
        } else {
            throw IDMMessages.MESSAGES.relationshipUnsupportedGroupMemberType(identityType);
        }
        return isMember;
    }

    public void addToGroup(Agent member, Group group) {
        this.checkIfIdentityTypeExists((IdentityType)member);
        this.checkIfIdentityTypeExists((IdentityType)group);
        if (this.getGroupMembership((IdentityType)member, group) == null) {
            this.add((Relationship)new GroupMembership(member, group));
        }
    }

    public void removeFromGroup(Agent member, Group group) {
        this.checkIfIdentityTypeExists((IdentityType)member);
        this.checkIfIdentityTypeExists((IdentityType)group);
        this.storeFactory.getStoreForFeature(this.context, FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.delete, GroupMembership.class).remove(this.context, (AttributedType)new GroupMembership(member, group));
    }

    public Role getRole(String name) {
        return this.storeFactory.getStoreForFeature(this.context, FeatureSet.FeatureGroup.role, FeatureSet.FeatureOperation.read).getRole(this.context, name);
    }

    public boolean hasGroupRole(IdentityType assignee, Role role, Group group) {
        if (assignee == null) {
            IDMMessages.MESSAGES.nullArgument("IdentityType");
        }
        if (role == null) {
            IDMMessages.MESSAGES.nullArgument("Role");
        }
        if (group == null) {
            IDMMessages.MESSAGES.nullArgument("Group");
        }
        return this.getGroupRole(assignee, role, group) != null;
    }

    public void grantGroupRole(IdentityType assignee, Role role, Group group) {
        this.checkIfIdentityTypeExists(assignee);
        this.checkIfIdentityTypeExists((IdentityType)role);
        this.checkIfIdentityTypeExists((IdentityType)group);
        if (this.getGroupRole(assignee, role, group) == null) {
            this.add((Relationship)new GroupRole(assignee, group, role));
        }
    }

    public void revokeGroupRole(IdentityType assignee, Role role, Group group) {
        this.checkIfIdentityTypeExists(assignee);
        this.checkIfIdentityTypeExists((IdentityType)role);
        this.checkIfIdentityTypeExists((IdentityType)group);
        this.storeFactory.getStoreForFeature(this.context, FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.delete, GroupRole.class).remove(this.context, (AttributedType)new GroupRole(assignee, group, role));
    }

    public boolean hasRole(IdentityType identityType, Role role) {
        if (identityType == null) {
            IDMMessages.MESSAGES.nullArgument("IdentityType");
        }
        if (role == null) {
            IDMMessages.MESSAGES.nullArgument("Role");
        }
        if (Role.class.isInstance(identityType)) {
            throw IDMMessages.MESSAGES.relationshipUnsupportedGrantAssigneeType(identityType);
        }
        return this.getGrant(identityType, role) != null;
    }

    public void grantRole(IdentityType identityType, Role role) {
        if (Role.class.isInstance(identityType)) {
            throw IDMMessages.MESSAGES.relationshipUnsupportedGrantAssigneeType(identityType);
        }
        this.checkIfIdentityTypeExists(identityType);
        this.checkIfIdentityTypeExists((IdentityType)role);
        if (this.getGrant(identityType, role) == null) {
            this.add((Relationship)new Grant(identityType, role));
        }
    }

    public void revokeRole(IdentityType identityType, Role role) {
        if (Role.class.isInstance(identityType)) {
            throw IDMMessages.MESSAGES.relationshipUnsupportedGrantAssigneeType(identityType);
        }
        this.checkIfIdentityTypeExists(identityType);
        this.checkIfIdentityTypeExists((IdentityType)role);
        this.storeFactory.getStoreForFeature(this.context, FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.delete, Grant.class).remove(this.context, (AttributedType)new Grant(identityType, role));
    }

    public void validateCredentials(Credentials credentials) {
        IdentityStore store = this.storeFactory.getStoreForFeature(this.context, FeatureSet.FeatureGroup.credential, FeatureSet.FeatureOperation.validate);
        store.validateCredentials(this.context, credentials);
    }

    public void updateCredential(Agent agent, Object value) {
        this.updateCredential(agent, value, new Date(), null);
    }

    public void updateCredential(Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        IdentityStore store = this.storeFactory.getStoreForFeature(this.context, FeatureSet.FeatureGroup.credential, FeatureSet.FeatureOperation.update);
        store.updateCredential(this.context, agent, credential, effectiveDate, expiryDate);
    }

    public <T extends IdentityType> IdentityQuery<T> createIdentityQuery(Class<T> identityType) {
        return new DefaultIdentityQuery<T>(this.context, identityType, this.storeFactory.getStoreForFeature(this.context, FeatureSet.FeatureGroup.user, FeatureSet.FeatureOperation.read));
    }

    public <T extends Relationship> RelationshipQuery<T> createRelationshipQuery(Class<T> relationshipType) {
        return new DefaultRelationshipQuery<T>(this.context, relationshipType, this.storeFactory.getStoreForFeature(this.context, FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.read, relationshipType));
    }

    public <T extends IdentityType> T lookupIdentityById(Class<T> identityType, String id) {
        if (identityType == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityType class");
        }
        if (id == null) {
            throw IDMMessages.MESSAGES.nullArgument("Identifier for [" + identityType + "]");
        }
        IdentityQuery<T> query = this.createIdentityQuery(identityType);
        query.setParameter(IdentityType.ID, new Object[]{id});
        List result = query.getResultList();
        IdentityType identity = null;
        if (!result.isEmpty()) {
            if (result.size() > 1) {
                throw IDMMessages.MESSAGES.identityTypeAmbiguosFoundWithId(id);
            }
            identity = (IdentityType)result.get(0);
        }
        return (T)identity;
    }

    public void loadAttribute(IdentityType identityType, String attributeName) {
    }

    private GroupRole getGroupRole(IdentityType identityType, Role role, Group group) {
        RelationshipQuery<GroupRole> query = this.createRelationshipQuery(GroupRole.class);
        query.setParameter((QueryParameter)GroupRole.ASSIGNEE, new Object[]{identityType});
        query.setParameter((QueryParameter)GroupRole.ROLE, new Object[]{role});
        query.setParameter((QueryParameter)GroupRole.GROUP, new Object[]{group});
        List result = query.getResultList();
        GroupRole groupRole = null;
        if (!result.isEmpty()) {
            groupRole = (GroupRole)result.get(0);
        }
        return groupRole;
    }

    private GroupMembership getGroupMembership(IdentityType identityType, Group group) {
        RelationshipQuery<GroupMembership> query = this.createRelationshipQuery(GroupMembership.class);
        query.setParameter((QueryParameter)GroupMembership.MEMBER, new Object[]{identityType});
        query.setParameter((QueryParameter)GroupMembership.GROUP, new Object[]{group});
        List result = query.getResultList();
        GroupMembership groupMembership = null;
        if (!result.isEmpty()) {
            groupMembership = (GroupMembership)result.get(0);
        }
        return groupMembership;
    }

    private void checkIfIdentityTypeExists(IdentityType identityType) throws IdentityManagementException {
        if (identityType == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityType");
        }
        if (this.lookupIdentityById(identityType.getClass(), identityType.getId()) == null) {
            throw IDMMessages.MESSAGES.attributedTypeNotFoundWithId(identityType.getClass(), identityType.getId(), this.context.getPartition());
        }
    }

    private Grant getGrant(IdentityType identityType, Role role) {
        RelationshipQuery<Grant> query = this.createRelationshipQuery(Grant.class);
        query.setParameter((QueryParameter)Grant.ASSIGNEE, new Object[]{identityType});
        query.setParameter((QueryParameter)Grant.ROLE, new Object[]{role});
        List result = query.getResultList();
        Grant grant = null;
        if (!result.isEmpty()) {
            grant = (Grant)result.get(0);
        }
        return grant;
    }

    private void checkCurrentPartitionForAgents() throws IdentityManagementException {
        if (!Realm.class.isInstance(this.context.getPartition())) {
            throw IDMMessages.MESSAGES.partitionInvalidTypeForAgents(this.context.getPartition().getClass());
        }
    }
}

