/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import org.picketlink.idm.IDMLogger;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.IdentityManagerFactory;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.internal.DefaultIdentityManager;
import org.picketlink.idm.internal.DefaultSecurityContextFactory;
import org.picketlink.idm.internal.DefaultStoreFactory;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.spi.SecurityContext;
import org.picketlink.idm.spi.SecurityContextFactory;
import org.picketlink.idm.spi.StoreFactory;

public class DefaultIdentityManagerFactory
implements IdentityManagerFactory {
    private SecurityContextFactory contextFactory;
    private StoreFactory storeFactory;

    public DefaultIdentityManagerFactory(IdentityConfiguration identityConfig) {
        this(identityConfig, new DefaultSecurityContextFactory());
    }

    public DefaultIdentityManagerFactory(IdentityConfiguration identityConfig, SecurityContextFactory contextFactory) {
        this(identityConfig, contextFactory, new DefaultStoreFactory(identityConfig));
    }

    public DefaultIdentityManagerFactory(IdentityConfiguration identityConfig, SecurityContextFactory contextFactory, StoreFactory storeFactory) {
        if (identityConfig == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityConfiguration");
        }
        if (contextFactory == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityStoreInvocationContextFactory");
        }
        IDMLogger.LOGGER.identityManagerBootstrapping();
        this.contextFactory = contextFactory;
        this.storeFactory = storeFactory;
    }

    public void setIdentityStoreFactory(StoreFactory factory) {
        this.storeFactory = factory;
    }

    public void setContextFactory(SecurityContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public IdentityManager createIdentityManager() {
        Realm defaultRealm = this.getRealm("default");
        if (defaultRealm == null) {
            throw IDMMessages.MESSAGES.configurationDefaultRealmNotDefined();
        }
        return this.createIdentityManager((Partition)defaultRealm);
    }

    public IdentityManager createIdentityManager(Partition partition) {
        if (partition == null) {
            throw IDMMessages.MESSAGES.nullArgument("Partition");
        }
        SecurityContext context = this.contextFactory.createContext(partition);
        return new DefaultIdentityManager(context, this.storeFactory);
    }

    public Realm getRealm(String id) {
        return this.storeFactory.getRealm(id);
    }

    public Tier getTier(String id) {
        return this.storeFactory.getTier(id);
    }
}

